/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;
import webwork.action.ServletActionContext;
import webwork.view.velocity.VelocityHelper;
import webwork.view.velocity.WebWorkUtil;

public class WebWorkVelocityServlet
extends VelocityServlet {
    protected static final String CONTEXT = "velocity_context";
    protected static final String WEBWORK_UTIL = "webwork";
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void init() throws ServletException {
        try {
            VelocityHelper.initVelocity(this.getServletContext());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(ServletRequest aRequest, ServletResponse aResponse) throws ServletException, IOException {
        long start = 0L;
        if (this.log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        super.service(aRequest, aResponse);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Time:" + (System.currentTimeMillis() - start)));
        }
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return VelocityHelper.getContext(this.getServletContext(), (ServletRequest)request, (ServletResponse)response);
    }

    protected Template handleRequest(HttpServletRequest aRequest, HttpServletResponse aResponse, Context ctx) throws Exception {
        ServletActionContext.setContext(aRequest, aResponse, this.getServletContext(), null);
        ctx.put(WEBWORK_UTIL, (Object)new WebWorkUtil(ctx));
        String servletPath = (String)aRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        return this.getTemplate(servletPath);
    }
}

