/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import webwork.util.ClassLoaderUtils;
import webwork.util.classloader.BytesURLStreamHandler;
import webwork.util.classloader.WebworkClassLoader;

public class JarClassLoader
extends WebworkClassLoader {
    private JarFile jar;
    private File file;
    private long jarLastModified;

    public JarClassLoader(File file, ClassLoader parent) {
        super(parent);
        this.file = file;
    }

    @Override
    public boolean isStale() {
        return new File(this.jar.getName()).lastModified() > this.jarLastModified;
    }

    @Override
    protected URL getDataURL(String name, byte[] data) throws MalformedURLException {
        return new URL(null, this.file.toURL().toExternalForm() + '!' + name, new BytesURLStreamHandler(data));
    }

    private void openJar() throws IOException {
        if (this.jar == null) {
            this.jar = new JarFile(this.file);
            this.jarLastModified = this.file.lastModified();
        }
    }

    @Override
    public synchronized byte[] getFile(String path) {
        try {
            this.openJar();
            ZipEntry entry = this.jar.getEntry(path);
            if (entry == null) {
                return null;
            }
            InputStream in = this.jar.getInputStream(entry);
            int size = (int)entry.getSize();
            byte[] data = ClassLoaderUtils.readStream(in, size);
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object clone() {
        JarClassLoader loader = new JarClassLoader(this.file, this.getParent());
        loader.packages = this.packages;
        return loader;
    }
}

