/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.IllegalArgumentAware;
import webwork.action.ValidationEditorSupport;
import webwork.util.InjectionUtils;
import webwork.util.Query;
import webwork.util.QuerySegment;
import webwork.util.editor.BigDecimalEditor;
import webwork.util.editor.BooleanEditor;
import webwork.util.editor.BooleanObjectEditor;
import webwork.util.editor.ByteEditor;
import webwork.util.editor.ByteObjectEditor;
import webwork.util.editor.DateEditor;
import webwork.util.editor.DateFormatEditor;
import webwork.util.editor.DoubleEditor;
import webwork.util.editor.DoubleObjectEditor;
import webwork.util.editor.FastPropertyEditor;
import webwork.util.editor.FloatEditor;
import webwork.util.editor.FloatObjectEditor;
import webwork.util.editor.IntegerEditor;
import webwork.util.editor.IntegerObjectEditor;
import webwork.util.editor.LongEditor;
import webwork.util.editor.LongObjectEditor;
import webwork.util.editor.PropertyEditorException;
import webwork.util.editor.ShortEditor;
import webwork.util.editor.ShortObjectEditor;
import webwork.util.editor.StringEditor;
import webwork.util.editor.TimestampEditor;
import webwork.util.injection.ObjectFactory;

public final class BeanUtil {
    static Map propertyDescriptors = new WeakHashMap();
    static Map propertyEditors = new HashMap();
    static Map objectMap = new WeakHashMap();
    static final Log log = LogFactory.getLog(BeanUtil.class);

    public static void copy(Object from, Object to) throws IllegalArgumentException {
        BeanUtil.copy(from, to, true);
    }

    public static void copy(Object from, Object to, boolean includeNull) throws IllegalArgumentException {
        try {
            Object[] readParameters = new Object[]{};
            Object[] writeParameters = new Object[1];
            PropertyDescriptor[] propertiesFrom = BeanUtil.getPropertyDescriptors(from.getClass());
            Map fieldMap = BeanUtil.getFieldMapForClass(to.getClass());
            for (int i = 0; i < propertiesFrom.length; ++i) {
                PropertyDescriptor pdFrom = propertiesFrom[i];
                PropertyDescriptor pdTo = (PropertyDescriptor)fieldMap.get(pdFrom.getName());
                if (pdTo == null) continue;
                Method readMethod = pdFrom.getReadMethod();
                Method writeMethod = pdTo.getWriteMethod();
                if (writeMethod == null || readMethod == null) continue;
                writeParameters[0] = InjectionUtils.invoke(pdFrom.getReadMethod(), from, readParameters);
                if (!includeNull && writeParameters[0] == null) continue;
                InjectionUtils.invoke(pdTo.getWriteMethod(), to, writeParameters);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Bean copy failed:" + e), (Throwable)e);
            throw new IllegalArgumentException("Bean copy failed:" + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setProperties(Map from, Object to) throws IllegalArgumentException {
        String key = null;
        Object value = null;
        try {
            Iterator keys = from.keySet().iterator();
            Map fieldMap = null;
            if (keys.hasNext()) {
                fieldMap = BeanUtil.getFieldMapForClass(to.getClass());
            }
            while (keys.hasNext()) {
                key = (String)keys.next();
                if (key == null || key.length() <= 0) continue;
                try {
                    value = from.get(key);
                    BeanUtil.setProperty(key, value, to, fieldMap);
                }
                catch (IllegalArgumentException e) {
                    if (!(to instanceof IllegalArgumentAware)) throw e;
                    ((IllegalArgumentAware)to).addIllegalArgumentException(key, e);
                    continue;
                    return;
                }
            }
        }
        catch (Exception propertySetException) {
            throw new IllegalArgumentException("Could not set parameter: '" + key + "' with value: '" + value + "' on class: " + to.getClass(), propertySetException);
        }
    }

    public static void setProperty(String propertyName, Object val, Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("The target object for property '" + propertyName + "'. The target object needs to be initialized to a non-null value in order to set this property.");
        }
        Map fieldMap = BeanUtil.getFieldMapForClass(obj.getClass());
        BeanUtil.setProperty(propertyName, val, obj, fieldMap);
    }

    private static void setProperty(String propertyName, Object val, Object obj, Map fieldMap) throws IllegalArgumentException {
        Query query = Query.getQuery(propertyName);
        QuerySegment[] segments = query.getSegments();
        Object curObject = obj;
        int totalNumberOfSegments = BeanUtil.findTheActualNumberOfSegments(segments);
        for (int i = 0; i < totalNumberOfSegments; ++i) {
            QuerySegment curSegment;
            if (curObject == null) {
                throw new IllegalArgumentException("The target object for property '" + propertyName + "'. The target object needs to be initialized to a non-null value in order to set this property.");
            }
            Map curFieldMap = curObject != obj ? BeanUtil.getFieldMapForClass(curObject.getClass()) : fieldMap;
            PropertyDescriptor descriptor = (PropertyDescriptor)curFieldMap.get((curSegment = segments[i]).getId());
            if (descriptor == null && curSegment.getType() != 9) {
                return;
            }
            if (curSegment.getType() == 9) {
                String key = curSegment.getId();
                if (Map.class.isAssignableFrom(curObject.getClass())) {
                    curObject = ((Map)curObject).get(key);
                    continue;
                }
                if (ResourceBundle.class.isAssignableFrom(curObject.getClass())) {
                    curObject = ((ResourceBundle)curObject).getObject(key);
                    continue;
                }
                if (curObject.getClass().isArray()) {
                    curObject = ((Object[])curObject)[Integer.parseInt(key)];
                    continue;
                }
                if (List.class.isAssignableFrom(curObject.getClass())) {
                    curObject = ((List)curObject).get(Integer.parseInt(key));
                    continue;
                }
                if (!Collection.class.isAssignableFrom(curObject.getClass())) continue;
                curObject = ((Collection)curObject).toArray()[Integer.parseInt(key)];
                continue;
            }
            if (curSegment.getType() == 8) {
                try {
                    if (descriptor instanceof IndexedPropertyDescriptor) {
                        throw new IllegalArgumentException("Attempting to set a indexed field " + curSegment.getId() + " as an non-indexed field");
                    }
                    if (i + 1 == totalNumberOfSegments) {
                        BeanUtil.setValue(curObject, descriptor, val);
                        return;
                    }
                    Method m = descriptor.getReadMethod();
                    if (m == null) {
                        throw new IllegalArgumentException("Read Method " + descriptor.getName() + " for " + curObject.getClass().getName() + " was not found");
                    }
                    curObject = InjectionUtils.invoke(m, curObject, new Object[0]);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception e) {
                    log.warn((Object)("Error executing read method for " + descriptor.getName() + " on " + curObject.getClass().getName()), (Throwable)e);
                    throw new IllegalArgumentException("Error executing read method for " + descriptor.getName() + " on " + curObject.getClass().getName());
                }
            }
            if (curSegment.getType() != 10) continue;
            Integer index = BeanUtil.getIndexedPropertyIndex(curSegment);
            try {
                Method m;
                if (i + 1 == totalNumberOfSegments) {
                    if (descriptor instanceof IndexedPropertyDescriptor) {
                        BeanUtil.setIndexedValue(curObject, (IndexedPropertyDescriptor)descriptor, val, index);
                        return;
                    }
                    throw new IllegalArgumentException("Attempting to set non-indexed field \"" + curSegment.getId() + "\" as an indexed field");
                }
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    m = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
                    if (m == null) {
                        throw new IllegalArgumentException("Indexed Read Method " + descriptor.getName() + " for " + curObject.getClass().getName() + " was not found");
                    }
                } else {
                    throw new IllegalArgumentException("Attempting to access non-indexed field \"" + curSegment.getId() + "\" as an indexed field");
                }
                curObject = InjectionUtils.invoke(m, curObject, new Object[]{index});
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error executing index read method for " + (descriptor != null ? descriptor.getName() : "<null>") + " on " + (curObject != null ? curObject.getClass().getName() : "<null>"));
            }
        }
    }

    public static PropertyEditor getPropertyEditor(Class clazz) {
        Object editor = propertyEditors.get(clazz);
        if (editor == null) {
            editor = PropertyEditorManager.findEditor(clazz);
            if (editor == null) {
                Map newEditorMap = (Map)((HashMap)propertyEditors).clone();
                newEditorMap.put(clazz, new Byte("0"));
                propertyEditors = newEditorMap;
                log.debug((Object)("PropertyEditorManager.findEditor returned null for class: " + clazz.getName()));
            } else if (editor instanceof FastPropertyEditor) {
                Map newEditorMap = (Map)((HashMap)propertyEditors).clone();
                newEditorMap.put(clazz, editor);
                propertyEditors = newEditorMap;
            }
        } else if (editor instanceof Byte) {
            return null;
        }
        return (PropertyEditor)editor;
    }

    public static Object getAsValue(PropertyEditor pe, String txt) {
        if (pe instanceof FastPropertyEditor) {
            return ((FastPropertyEditor)((Object)pe)).getAsValue(txt);
        }
        pe.setAsText(txt);
        return pe.getValue();
    }

    public static String toStringValue(Object obj) {
        String result = "";
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            PropertyEditor pe = BeanUtil.getPropertyEditor(obj.getClass());
            if (pe != null) {
                if (pe instanceof FastPropertyEditor) {
                    result = ((FastPropertyEditor)((Object)pe)).getAsText(obj);
                } else if (pe instanceof ValidationEditorSupport) {
                    pe.setValue(obj);
                    result = pe.getAsText();
                } else {
                    result = obj.toString();
                }
            } else {
                result = obj.toString();
            }
        }
        return result;
    }

    private static Integer getIndexedPropertyIndex(QuerySegment curSegment) {
        Integer index;
        try {
            List<Object> values = curSegment.getValues();
            if (values.size() != 1) {
                throw new IllegalArgumentException("Only Indexed properties allowed!");
            }
            Object value = values.get(0);
            index = value instanceof Query ? new Integer(((Query)value).getSegments()[0].getValues().get(0).toString()) : new Integer(values.get(0).toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only Indexed properties allowed! - Parameter must be an integer ");
        }
        return index;
    }

    private static int findTheActualNumberOfSegments(QuerySegment[] segments) {
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i] != null) continue;
            return i;
        }
        return segments.length;
    }

    private static boolean setValue(Object obj, PropertyDescriptor descriptor, Object val) throws IllegalArgumentException {
        if (descriptor == null || descriptor.getWriteMethod() == null) {
            log.debug((Object)"No descriptor found for. Unable to set value. ");
            return false;
        }
        if (val == null) {
            return false;
        }
        Method m = descriptor.getWriteMethod();
        Class<?> valueClass = val.getClass();
        Class<?>[] parameterClasses = m.getParameterTypes();
        Class<?> parameterClass = parameterClasses[0];
        if (!(valueClass.equals(String.class) || valueClass.equals(String[].class) || parameterClass.equals(String.class))) {
            return BeanUtil.setObjectDirectly(parameterClass, valueClass, val, m, obj);
        }
        String[] value = BeanUtil.convertObjectToStringArray(val);
        if (value != null) {
            if (descriptor.getPropertyEditorClass() == null && BeanUtil.setStringValueDirectly(obj, descriptor, value)) {
                return true;
            }
            BeanUtil.setStringValueWithPropertyEditor(obj, descriptor, value, parameterClass);
            return true;
        }
        return false;
    }

    private static String[] convertObjectToStringArray(Object val) {
        Class<?> valueClass = val.getClass();
        if (valueClass.equals(String.class)) {
            return new String[]{(String)val};
        }
        if (valueClass.equals(String[].class)) {
            return (String[])val;
        }
        return new String[]{val.toString()};
    }

    private static boolean setIndexedValue(Object obj, IndexedPropertyDescriptor descriptor, Object val, Integer index) {
        if (descriptor == null) {
            log.info((Object)"no descriptor found");
            return false;
        }
        Method m = descriptor.getIndexedWriteMethod();
        Class<?> valueClass = val.getClass();
        Class<?> parameterClass = m.getParameterTypes()[1];
        if (!(valueClass.equals(String.class) || valueClass.equals(String[].class) || parameterClass.equals(String.class))) {
            return BeanUtil.setIndexedObjectDirectly(parameterClass, valueClass, val, m, obj, index);
        }
        String[] value = BeanUtil.convertObjectToStringArray(val);
        if (value != null) {
            if (descriptor.getPropertyEditorClass() == null && BeanUtil.setIndexedStringValueDirectly(obj, descriptor, value, index)) {
                return true;
            }
            BeanUtil.setIndexedStringValueWithPropertyEditor(obj, descriptor, value, index);
            return true;
        }
        return false;
    }

    private static boolean setIndexedObjectDirectly(Class parameterClass, Class valueClass, Object val, Method m, Object obj, Integer index) {
        if (!parameterClass.isAssignableFrom(valueClass)) {
            if (parameterClass.equals(Integer.TYPE)) {
                parameterClass = Integer.class;
            } else if (parameterClass.equals(Long.TYPE)) {
                parameterClass = Long.class;
            }
            if (Number.class.isAssignableFrom(valueClass) && Number.class.isAssignableFrom(parameterClass)) {
                if (Long.class.isAssignableFrom(parameterClass)) {
                    val = new Long(((Number)val).longValue());
                } else if (Integer.class.isAssignableFrom(parameterClass)) {
                    val = new Integer(((Number)val).intValue());
                }
            }
        }
        try {
            Object[] writeParameter = new Object[]{index, val};
            InjectionUtils.invoke(m, obj, writeParameter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean setObjectDirectly(Class parameterClass, Class valueClass, Object val, Method m, Object obj) {
        if (!parameterClass.isAssignableFrom(valueClass)) {
            if (parameterClass.equals(Integer.TYPE)) {
                parameterClass = Integer.class;
            } else if (parameterClass.equals(Long.TYPE)) {
                parameterClass = Long.class;
            }
            if (Number.class.isAssignableFrom(valueClass) && Number.class.isAssignableFrom(parameterClass)) {
                if (Long.class.isAssignableFrom(parameterClass)) {
                    val = new Long(((Number)val).longValue());
                } else if (Integer.class.isAssignableFrom(parameterClass)) {
                    val = new Integer(((Number)val).intValue());
                }
            }
        }
        try {
            Object[] writeParameter = new Object[]{val};
            InjectionUtils.invoke(m, obj, writeParameter);
            return true;
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            return false;
        }
    }

    private static boolean setStringValueDirectly(Object obj, PropertyDescriptor descriptor, String[] values) throws IllegalArgumentException {
        try {
            Method m = descriptor.getWriteMethod();
            if (descriptor.getPropertyType().equals(String.class) || descriptor.getPropertyType().equals(Object.class)) {
                InjectionUtils.invoke(m, obj, new Object[]{values[0]});
                return true;
            }
            if (descriptor.getPropertyType().equals(String[].class)) {
                InjectionUtils.invoke(m, obj, new Object[]{values});
                return true;
            }
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(e.toString());
        }
        return false;
    }

    private static void setStringValueWithPropertyEditor(Object obj, PropertyDescriptor descriptor, String[] values, Class paramClass) throws IllegalArgumentException {
        block13: {
            try {
                PropertyEditor pe = BeanUtil.getPropertyEditor(descriptor);
                Method m = descriptor.getWriteMethod();
                if (pe == null) {
                    throw new IllegalArgumentException("No property editor registered for this type");
                }
                try {
                    try {
                        Class<?> compType = paramClass.getComponentType();
                        if (compType != null) {
                            Object a = Array.newInstance(compType, values.length);
                            for (int i = 0; i < values.length; ++i) {
                                Array.set(a, i, BeanUtil.getAsValue(pe, values[i]));
                            }
                            InjectionUtils.invoke(m, obj, new Object[]{a});
                        } else {
                            Object realValue = BeanUtil.getAsValue(pe, values[0]);
                            InjectionUtils.invoke(m, obj, new Object[]{realValue});
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new PropertyEditorException("BAD_VALUE", values[0]);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (obj instanceof IllegalArgumentAware) {
                        ((IllegalArgumentAware)obj).addIllegalArgumentException(descriptor.getName(), ex);
                        break block13;
                    }
                    throw ex;
                }
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                Throwable t;
                if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    private static void setIndexedStringValueWithPropertyEditor(Object obj, IndexedPropertyDescriptor descriptor, String[] values, Integer index) throws IllegalArgumentException {
        try {
            PropertyEditor pe = BeanUtil.getPropertyEditor(descriptor);
            Method m = descriptor.getIndexedWriteMethod();
            if (pe == null) {
                throw new IllegalArgumentException("No property editor registered for this type");
            }
            Object realValue = BeanUtil.getAsValue(pe, values[0]);
            InjectionUtils.invoke(m, obj, new Object[]{index, realValue});
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(e.toString());
        }
    }

    private static boolean setIndexedStringValueDirectly(Object obj, IndexedPropertyDescriptor descriptor, String[] values, Integer index) throws IllegalArgumentException {
        try {
            Method m = descriptor.getIndexedWriteMethod();
            if (descriptor.getIndexedPropertyType().equals(String.class) || descriptor.getIndexedPropertyType().equals(Object.class)) {
                InjectionUtils.invoke(m, obj, new Object[]{index, values[0]});
                return true;
            }
            if (descriptor.getIndexedPropertyType().equals(String[].class)) {
                InjectionUtils.invoke(m, obj, new Object[]{index, values});
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
                log.error((Object)("Error invoking indexed property method " + descriptor.getIndexedWriteMethod().getName() + " index=" + index + " values=" + Arrays.asList(values)), t);
                throw new IllegalArgumentException(t.toString());
            }
            throw new IllegalArgumentException(e.toString());
        }
        return false;
    }

    private static Map getFieldMapForClass(Class objClass) {
        Map fieldMap = (Map)objectMap.get(objClass);
        if (fieldMap == null && (fieldMap = BeanUtil.buildFieldMap(objClass)) != null) {
            objectMap.put(objClass, fieldMap);
        }
        return fieldMap;
    }

    private static Map buildFieldMap(Class objClass) {
        WeakHashMap<String, PropertyDescriptor> fieldMap = new WeakHashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] descriptors = BeanUtil.getPropertyDescriptors(objClass);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                fieldMap.put(descriptors[i].getName(), descriptors[i]);
            }
            return fieldMap;
        }
        return null;
    }

    private static PropertyEditor getPropertyEditor(PropertyDescriptor descriptor) {
        Class<?> peClass = descriptor.getPropertyEditorClass();
        try {
            if (peClass == null) {
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    return BeanUtil.getPropertyEditor(((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType());
                }
                return BeanUtil.getPropertyEditor(descriptor.getPropertyType());
            }
            return (PropertyEditor)ObjectFactory.instantiate(peClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private static synchronized PropertyDescriptor[] getPropertyDescriptors(Class objClass) {
        PropertyDescriptor[] descriptors = (PropertyDescriptor[])propertyDescriptors.get(objClass);
        if (descriptors == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(objClass, Object.class);
            }
            catch (IntrospectionException e) {
                return new PropertyDescriptor[0];
            }
            descriptors = beanInfo.getPropertyDescriptors();
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(descriptors.length);
            for (int i = 0; i < descriptors.length; ++i) {
                Method writeMethod;
                Method readMethod;
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
                    if (!BeanUtil.verifyNotObjectProperty(readMethod, writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod())) continue;
                    list.add(descriptor);
                    continue;
                }
                readMethod = descriptor.getReadMethod();
                if (!BeanUtil.verifyNotObjectProperty(readMethod, writeMethod = descriptor.getWriteMethod())) continue;
                list.add(descriptor);
            }
            descriptors = new PropertyDescriptor[list.size()];
            list.toArray(descriptors);
            propertyDescriptors.put(objClass, descriptors);
        }
        return descriptors;
    }

    private static boolean verifyNotObjectProperty(Method readMethod, Method writeMethod) {
        return readMethod != null && !readMethod.getDeclaringClass().equals(Object.class) || writeMethod != null && !writeMethod.getDeclaringClass().equals(Object.class);
    }

    static {
        PropertyEditorManager.registerEditor(Integer.class, IntegerObjectEditor.class);
        PropertyEditorManager.registerEditor(Integer[].class, IntegerObjectEditor.class);
        PropertyEditorManager.registerEditor(Integer.TYPE, IntegerEditor.class);
        PropertyEditorManager.registerEditor(int[].class, IntegerEditor.class);
        PropertyEditorManager.registerEditor(Double.class, DoubleObjectEditor.class);
        PropertyEditorManager.registerEditor(Double[].class, DoubleObjectEditor.class);
        PropertyEditorManager.registerEditor(Double.TYPE, DoubleEditor.class);
        PropertyEditorManager.registerEditor(double[].class, DoubleEditor.class);
        PropertyEditorManager.registerEditor(Byte.class, ByteObjectEditor.class);
        PropertyEditorManager.registerEditor(Byte[].class, ByteObjectEditor.class);
        PropertyEditorManager.registerEditor(Byte.TYPE, ByteEditor.class);
        PropertyEditorManager.registerEditor(byte[].class, ByteEditor.class);
        PropertyEditorManager.registerEditor(Short.class, ShortObjectEditor.class);
        PropertyEditorManager.registerEditor(Short[].class, ShortObjectEditor.class);
        PropertyEditorManager.registerEditor(Short.TYPE, ShortEditor.class);
        PropertyEditorManager.registerEditor(short[].class, ShortEditor.class);
        PropertyEditorManager.registerEditor(Long.class, LongObjectEditor.class);
        PropertyEditorManager.registerEditor(Long[].class, LongObjectEditor.class);
        PropertyEditorManager.registerEditor(Long.TYPE, LongEditor.class);
        PropertyEditorManager.registerEditor(long[].class, LongEditor.class);
        PropertyEditorManager.registerEditor(Float.class, FloatObjectEditor.class);
        PropertyEditorManager.registerEditor(Float[].class, FloatObjectEditor.class);
        PropertyEditorManager.registerEditor(Float.TYPE, FloatEditor.class);
        PropertyEditorManager.registerEditor(float[].class, FloatEditor.class);
        PropertyEditorManager.registerEditor(Boolean.class, BooleanObjectEditor.class);
        PropertyEditorManager.registerEditor(Boolean[].class, BooleanObjectEditor.class);
        PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
        PropertyEditorManager.registerEditor(boolean[].class, BooleanEditor.class);
        PropertyEditorManager.registerEditor(String.class, StringEditor.class);
        PropertyEditorManager.registerEditor(String[].class, StringEditor.class);
        PropertyEditorManager.registerEditor(BigDecimal.class, BigDecimalEditor.class);
        PropertyEditorManager.registerEditor(BigDecimal[].class, BigDecimalEditor.class);
        PropertyEditorManager.registerEditor(Date.class, DateEditor.class);
        PropertyEditorManager.registerEditor(Date[].class, DateEditor.class);
        PropertyEditorManager.registerEditor(Timestamp.class, TimestampEditor.class);
        PropertyEditorManager.registerEditor(Timestamp[].class, TimestampEditor.class);
        PropertyEditorManager.registerEditor(DateFormat.class, DateFormatEditor.class);
    }
}

