/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.List;

public abstract class PrimitivesWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler,
            Object value, String attributeName, List walkedInstances) throws SAXException
    {
        contentHandler.startElement("", attributeName, "", EMPTY_ATTRS);
        String string = value.toString();
        contentHandler.characters(string.toCharArray(), 0, string.length());
        contentHandler.endElement("", attributeName, "");
    }
}
