package webwork.config.util;

import java.util.Map;
import java.util.Set;

/**
 * This returns information about an Action
 */
public interface ActionInfo
{
    /**
     * @return the name of the action
     */
    String getActionName();

    /**
     * @return the alias of the action
     */
    String getActionAlias();

    /**
     * @return the source of this info, eg where it was read from.  If its null it was read from a system place like actions.xml
     */
    public String getSource();

    /**
     * @return a set of all the attribute names used when defining the Action
     */
    Set<String> getAttributeNames();

    /**
     * The value of a named attribute or null if its not known about
     *
     * @param attributeName the name of the attribute to return.
     * @return the value of a named attribute or null if its not known about
     */
    String getAttributeValue(String attributeName);

    /**
     * @return the attributes in {@link Map} form
     */
    Map<String, String> getAttributes();


    /**
     * @return information about this
     */
    Iterable<ViewInfo> getViews();


    interface ViewInfo
    {
        /**
         * @return the parent {@link ActionInfo} for the action that is related to this view
         */
        ActionInfo getActionInfo();

        /**
         * @return the name of the view
         */
        String getViewName();

        /**
         * @return the value of the view, ie what to execute as the view
         */
        String getViewValue();

        /**
         * @return a set of all the attribute names used when defining the View
         */
        Set<String> getAttributeNames();

        /**
         * The value of a named attribute or null if its not known about
         *
         * @param attributeName the name of the attribute to return.
         * @return the value of a named attribute or null if its not known about
         */
        String getAttributeValue(String attributeName);

        /**
         * @return the attributes in {@link Map} form
         */
        Map<String, String> getAttributes();

    }
}
