/*
 * Decompiled with CFR 0.152.
 */
package webwork.interceptor;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import webwork.action.Action;
import webwork.interceptor.ChainedInterceptor;
import webwork.interceptor.Interceptor;
import webwork.interceptor.InterceptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedInterceptorFactory
implements InterceptorFactory {
    private final ConcurrentMap<String, InterceptorFactoryHolder> factoryRegistrar = new ConcurrentHashMap<String, InterceptorFactoryHolder>();
    private final SortedSet<InterceptorFactoryHolder> factories = new ConcurrentSkipListSet<InterceptorFactoryHolder>(new InterceptorFactoryHolderComparator());
    private static final ChainedInterceptorFactory instance = new ChainedInterceptorFactory();

    public static ChainedInterceptorFactory getInstance() {
        return instance;
    }

    @Override
    public Interceptor createInterceptorFor(Action action) {
        return new ChainedInterceptor(this.createInterceptorsFor(action));
    }

    private List<Interceptor> createInterceptorsFor(Action action) {
        LinkedList<Interceptor> interceptors = new LinkedList<Interceptor>();
        for (InterceptorFactoryHolder holder : this.factories) {
            Interceptor interceptor = holder.factory.createInterceptorFor(action);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    public synchronized void register(String key, int weight, InterceptorFactory factory) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory is null.");
        }
        InterceptorFactoryHolder holder = new InterceptorFactoryHolder(key, factory, weight);
        InterceptorFactoryHolder replaced = this.factoryRegistrar.put(key, holder);
        if (replaced != null) {
            this.factories.remove(replaced);
        }
        this.factories.add(holder);
    }

    public synchronized boolean unregister(String key, InterceptorFactory factory) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory is null.");
        }
        InterceptorFactoryHolder holder = (InterceptorFactoryHolder)this.factoryRegistrar.get(key);
        if (holder == null) {
            return false;
        }
        if (holder.factory != factory) {
            return false;
        }
        this.factories.remove(holder);
        return this.factoryRegistrar.remove(key, holder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterceptorFactoryHolderComparator
    implements Comparator<InterceptorFactoryHolder> {
        private InterceptorFactoryHolderComparator() {
        }

        @Override
        public int compare(InterceptorFactoryHolder lhs, InterceptorFactoryHolder rhs) {
            int diff = lhs.weight - rhs.weight;
            if (diff != 0) {
                return diff;
            }
            if (lhs.equals(rhs)) {
                return 0;
            }
            return lhs.key.compareTo(rhs.key);
        }
    }

    private static class InterceptorFactoryHolder {
        private final InterceptorFactory factory;
        private final String key;
        private final int weight;

        InterceptorFactoryHolder(String key, InterceptorFactory factory, int weight) {
            this.key = key;
            this.factory = factory;
            this.weight = weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterceptorFactoryHolder that = (InterceptorFactoryHolder)o;
            if (this.factory != that.factory) {
                return false;
            }
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

