/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;

import webwork.action.ValidationEditorSupport;

/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.3 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 */
public class EmailEditor extends ValidationEditorSupport
{

    public void setAsText(String txt)
    {
        // Validate name
        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Email must be specified");
        }
        if (!Validator.checkEmail(txt, false))
        {
            throw new IllegalArgumentException("Email is not valid");
        }

        setValue(txt);
    }
}

