/*
 * Decompiled with CFR 0.152.
 */
package webwork.config.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webwork.config.util.ActionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionInfoImpl
implements ActionInfo {
    private final String actionName;
    private final String actionAlias;
    private final Map<String, String> attributes;
    private final List<ActionInfo.ViewInfo> viewInfos;
    private final String source;

    ActionInfoImpl(String actionName, String actionAlias, Map<String, String> attributeMap, String source, List<ActionInfo.ViewInfo> viewInfos) {
        this.actionName = actionName;
        this.actionAlias = actionAlias;
        this.attributes = attributeMap;
        this.source = source;
        this.viewInfos = viewInfos;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public String getActionAlias() {
        return this.actionAlias;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    @Override
    public Iterable<ActionInfo.ViewInfo> getViews() {
        return this.viewInfos;
    }

    public static Builder builder(String actionName, String actionAlias) {
        return new Builder(actionName, actionAlias);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String actionName;
        private String actionAlias;
        private String source;
        private Map<String, String> attributes = new HashMap<String, String>();
        private List<ActionInfo.ViewInfo> viewInfos = new ArrayList<ActionInfo.ViewInfo>();

        Builder(String actionName, String actionAlias) {
            this.actionName = actionName;
            this.actionAlias = actionAlias;
        }

        public Builder setSource(String sourceOfConfig) {
            this.source = sourceOfConfig;
            return this;
        }

        public Builder addAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder addAttribute(String attrName, String attrValue) {
            this.attributes.put(attrName, attrValue);
            return this;
        }

        public View startView(String viewName, String viewValue) {
            return new View(viewName, viewValue);
        }

        public ActionInfo build() {
            ActionInfoImpl actionInfo = new ActionInfoImpl(this.actionName, this.actionAlias, this.attributes, this.source, this.viewInfos);
            for (ActionInfo.ViewInfo viewInfo : this.viewInfos) {
                ((ViewInfoImpl)viewInfo).setActionInfo(actionInfo);
            }
            return actionInfo;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class View {
            private String viewName;
            private String viewValue;
            private Map<String, String> attributes = new HashMap<String, String>();

            View(String viewName, String viewValue) {
                this.viewName = viewName;
                this.viewValue = viewValue;
            }

            public View addAttributes(Map<String, String> attributes) {
                this.attributes.putAll(attributes);
                return this;
            }

            public View addAttribute(String attrName, String attrValue) {
                this.attributes.put(attrName, attrValue);
                return this;
            }

            public Builder endView() {
                Builder.this.viewInfos.add(new ViewInfoImpl(this.viewName, this.viewValue, this.attributes));
                return Builder.this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewInfoImpl
    implements ActionInfo.ViewInfo {
        private final String viewName;
        private final String viewValue;
        private final Map<String, String> attributes;
        private ActionInfo actionInfo;

        ViewInfoImpl(String viewName, String viewValue, Map<String, String> attributes) {
            this.viewName = viewName;
            this.viewValue = viewValue;
            this.attributes = attributes;
        }

        @Override
        public ActionInfo getActionInfo() {
            return this.actionInfo;
        }

        @Override
        public String getViewName() {
            return this.viewName;
        }

        @Override
        public String getViewValue() {
            return this.viewValue;
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        @Override
        public String getAttributeValue(String attributeName) {
            return this.attributes.get(attributeName);
        }

        @Override
        public Map<String, String> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        void setActionInfo(ActionInfo actionInfo) {
            this.actionInfo = actionInfo;
        }
    }
}

