/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * Checkbox tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class CheckBoxTag extends AbstractHTMLComponentTag
{
    // Attributes ----------------------------------------------------
    protected String fieldValue;
    protected String checked;

    // Public --------------------------------------------------------
    public String getTemplate()
    {
        return "checkbox";
    }

    public void setFieldValue(String aValue)
    {
        this.fieldValue = aValue;
    }
    
    public void setChecked(String checked)
    {
        this.checked = checked;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (fieldValue != null)
        {
            this.addParameter("fieldValue", findValue(fieldValue));
        }
        if (checked != null)
        {
            this.addParameter("checked", findValue(checked));
        }

        return super.doEndTag();
    }
}