/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

import webwork.action.ValidationEditorSupport;

/**
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.4 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 * @see FastPropertyEditor
 * @see PropertyEditorException
 */
public class ByteEditor extends ValidationEditorSupport implements FastPropertyEditor
{

    public void setAsText(String txt)
    {
        setValue(getAsValue(txt));
    }

    public Object getAsValue(String txt)
    {
        if (txt == null || txt.length() == 0)
        {
            throw new PropertyEditorException(PropertyMessage.EMPTY_BYTE, txt);
        }
        try
        {
            return new Byte(txt);
        }
        catch (NumberFormatException e)
        {
            throw new PropertyEditorException(PropertyMessage.BAD_BYTE, txt);
        }
    }
}

