/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.beans.Introspector;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.ActionContext;
import webwork.action.ResultException;
import webwork.action.ServletActionContext;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.ServletValueStack;
import webwork.util.ValueStack;

public class ServletDispatcher
extends HttpServlet {
    public static final String STACK_HEAD = "webwork.valuestack.head";
    protected static Log log = LogFactory.getLog(ServletDispatcher.class);
    private static String saveDir;
    private static Integer maxSize;
    private static String actionExtension;
    private String encoding;
    public static final String GENERIC_DISPATCHER_FOR_CLEANUP = "webwork.generic.dispatcher";

    public void init(ServletConfig config) throws ServletException {
        block13: {
            super.init(config);
            Introspector.flushCaches();
            ValueStack.clearMethods();
            try {
                saveDir = Configuration.getString("webwork.multipart.saveDir");
                if (saveDir.compareTo("") == 0) {
                    throw new IllegalArgumentException("saveDir=null");
                }
            }
            catch (IllegalArgumentException e) {
                File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
                log.info((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
                if (tempdir == null) break block13;
                saveDir = tempdir.toString();
            }
        }
        log.debug((Object)("saveDir=" + saveDir));
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException e) {
                    maxSize = new Integer(Integer.MAX_VALUE);
                    log.info((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = new Integer(Integer.MAX_VALUE);
                log.info((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException e1) {
            maxSize = new Integer(Integer.MAX_VALUE);
            log.info((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        log.debug((Object)("maxSize=" + maxSize));
        try {
            actionExtension = "." + Configuration.getString("webwork.action.extension");
        }
        catch (IllegalArgumentException iae) {
            actionExtension = ".action";
            log.info((Object)"Unable to find 'webwork.action.extension' property setting. Defaulting to 'action'");
        }
        try {
            this.encoding = Configuration.getString("webwork.i18n.encoding");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        log.debug((Object)("action extension=" + actionExtension));
        log.info((Object)"Action dispatcher initialized");
    }

    public void service(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException {
        Boolean skipCleaning;
        String servletPath = (String)(aRequest = this.wrapRequest(aRequest)).getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        String actionName = this.getActionName(servletPath);
        GenericDispatcher gd = new GenericDispatcher(actionName, false);
        ActionContext context = gd.prepareContext();
        ServletActionContext.setContext(aRequest, aResponse, this.getServletContext(), actionName);
        gd.prepareValueStack();
        ActionResult ar = null;
        try {
            gd.executeAction();
            ar = gd.finish();
        }
        catch (Throwable e) {
            log.error((Object)"Could not execute action", e);
            try {
                aResponse.sendError(404, "Could not execute action [" + actionName + "]:" + e.getMessage() + this.getHTMLErrorMessage(e));
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (ar != null && ar.getActionException() != null) {
            log.error((Object)"Could not execute action", (Throwable)ar.getActionException());
            try {
                aResponse.sendError(500, ar.getActionException().getMessage() + this.getHTMLErrorMessage(ar.getActionException()));
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (ar != null && ar.getResult() != null && ar.getView() == null && !ar.getResult().equals("none")) {
            try {
                aResponse.sendError(404, "No view for result [" + ar.getResult() + "] exists for action [" + actionName + "]");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (ar != null && ar.getView() != null && ar.getActionException() == null) {
            String view = ar.getView().toString();
            log.debug((Object)("Result:" + view));
            RequestDispatcher dispatcher = null;
            try {
                dispatcher = aRequest.getRequestDispatcher(view);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (dispatcher == null) {
                throw new ServletException("No presentation file with name '" + view + "' found!");
            }
            try {
                if (aRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                    aRequest.setAttribute("webwork.view_uri", (Object)view);
                    aRequest.setAttribute("webwork.request_uri", (Object)aRequest.getRequestURI());
                    dispatcher.forward((ServletRequest)aRequest, (ServletResponse)aResponse);
                } else {
                    dispatcher.include((ServletRequest)aRequest, (ServletResponse)aResponse);
                }
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                aRequest.setAttribute(STACK_HEAD, ServletValueStack.getStack((ServletRequest)aRequest).peek());
            }
        }
        if ((skipCleaning = (Boolean)aRequest.getAttribute("webwork.cleanupfilter")) != null && skipCleaning.booleanValue()) {
            aRequest.setAttribute(GENERIC_DISPATCHER_FOR_CLEANUP, (Object)gd);
        } else {
            gd.finalizeContext();
        }
    }

    protected String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.lastIndexOf(actionExtension);
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) {
        if (this.encoding != null) {
            try {
                request.setCharacterEncoding(this.encoding);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (request instanceof MultiPartRequestWrapper) {
            return request;
        }
        if (MultiPartRequest.isMultiPart(request)) {
            try {
                request = new MultiPartRequestWrapper((HttpServletRequest)request, saveDir, maxSize);
            }
            catch (IOException e) {
                request.setAttribute("webwork.action.ResultException", (Object)new ResultException("error", e.getLocalizedMessage()));
            }
        }
        return request;
    }

    protected String getHTMLErrorMessage(Throwable t) {
        return "<p><small><small><pre>" + ServletDispatcher.getStackTrace(t) + "</pre></small></small></p>";
    }

    private static String getStackTrace(Throwable t) {
        CharArrayWriter sink = new CharArrayWriter(400);
        PrintWriter exceptionWriter = new PrintWriter(sink);
        t.printStackTrace(exceptionWriter);
        return sink.toString();
    }
}

