/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import webwork.config.AbstractConfiguration;
import webwork.config.WebworkConfigurationNotFoundException;
import webwork.util.ClassLoaderUtils;

public class PropertiesConfiguration
extends AbstractConfiguration {
    Properties settings = new Properties();

    public PropertiesConfiguration(String aName) {
        URL settingsUrl = ClassLoaderUtils.getResource(aName + ".properties", PropertiesConfiguration.class);
        if (settingsUrl == null) {
            throw new IllegalStateException(aName + ".properties missing");
        }
        try {
            this.settings.load(settingsUrl.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + aName + ".properties:" + e);
        }
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        Object setting = this.settings.get(aName);
        if (setting == null) {
            throw new WebworkConfigurationNotFoundException(this.getClass(), "No such setting", aName);
        }
        return setting;
    }

    public void setImpl(String aName, Object aValue) {
        this.settings.put(aName, aValue);
    }

    public Iterator listImpl() {
        return this.settings.keySet().iterator();
    }
}

