/*
 * WebWork, web application framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;

/**
 * Get the java.beans.BeanInfo object for a given object
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.7 $
 * @see java.beans.BeanInfo
 */
public class BeanInfoUtil
{
    // Attributes ----------------------------------------------------
    Object bean;

    // Public --------------------------------------------------------

    /**
     * The object whose BeanInfo should be retrieved
     */
    public void setBean(Object aBean)
    {
        bean = aBean;
    }

    public BeanInfo getBeanInfo()
            throws IntrospectionException
    {
        return Introspector.getBeanInfo(bean.getClass(), Object.class);
    }
}


