/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.ActionContext;
import webwork.util.DateFormatter;

import java.util.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.text.DateFormat;
import java.lang.reflect.Array;

/**
 * Test util.BeanUtil
 *
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.3 $
 * @see <related>
 */
public class BeanUtilTest
        extends ActionSupport
{

    //primitives
    int primInt;
    double primDouble;
    short primShort;
    byte primByte;
    long primLong;
    float primFloat;
    boolean primBoolean;

    //objects
    Integer objInt = new Integer(0);
    Double objDouble = new Double(0.0);
    Short objShort = new Short("0");
    Byte objByte = new Byte("0");
    Long objLong = new Long(0);
    Float objFloat = new Float(0.0);
    Boolean objBoolean = new Boolean(false);
    Date objDate = new Date();

    //arrays - objects
    Integer[] defaultObjIntegers = { new Integer(1), new Integer(2), new Integer(3), new Integer(4) };
    Integer[] objIntegers;

    Double[] defaultObjDoubles = { new Double(1.0), new Double(2.0), new Double(3.0), new Double(4.0) };
    Double[] objDoubles;

    Short[] defaultObjShorts = { new Short("1"), new Short("2"), new Short("3"), new Short("4") };
    Short[] objShorts;

    Byte[] defaultObjBytes = { new Byte("1"), new Byte("2"), new Byte("3"), new Byte("4") };
    Byte[] objBytes;

    Long[] defaultObjLongs = { new Long(1), new Long(2), new Long(3), new Long(4) };
    Long[] objLongs;

    Float[] defaultObjFloats = { new Float(1.0), new Float(2.0), new Float(3.0), new Float(4.0) };
    Float[] objFloats;

    //arrays - primitives
    int[] defaultPrimInts = { 1, 2, 3, 4 };
    int[] primInts;

    double[] defaultPrimDoubles = { 1.0d, 2.0d, 3.0d, 4.0d };
    double[] primDoubles;

    short[] defaultPrimShorts = { (short) 1, (short) 2, (short) 3, (short) 4 };
    short[] primShorts;

    byte[] defaultPrimBytes = { (byte) 1, (byte) 2, (byte) 3, (byte) 4 };
    byte[] primBytes;

    long[] defaultPrimLongs = { (long) 1, (long) 2, (long) 3, (long) 4 };
    long[] primLongs;

    float[] defaultPrimFloats = { 1.0f, 2.0f, 3.0f, 4.0f };
    float[] primFloats;

    //-- arrays - primitives

    public int[] getDefaultPrimInts()
    {
        return defaultPrimInts;
    }

    public double[] getDefaultPrimDoubles()
    {
        return defaultPrimDoubles;
    }

    public short[] getDefaultPrimShorts()
    {
        return defaultPrimShorts;
    }

    public byte[] getDefaultPrimBytes()
    {
        return defaultPrimBytes;
    }

    public long[] getDefaultPrimLongs()
    {
        return defaultPrimLongs;
    }

    public float[] getDefaultPrimFloats()
    {
        return defaultPrimFloats;
    }

    public int[] getPrimInts()
    {
        return primInts;
    }

    public void setPrimInts(int[] primInts)
    {
        this.primInts = primInts;
    }

    public double[] getPrimDoubles()
    {
        return primDoubles;
    }

    public void setPrimDoubles(double[] primDoubles)
    {
        this.primDoubles = primDoubles;
    }

    public short[] getPrimShorts()
    {
        return primShorts;
    }

    public void setPrimShorts(short[] primShorts)
    {
        this.primShorts = primShorts;
    }

    public byte[] getPrimBytes()
    {
        return primBytes;
    }

    public void setPrimBytes(byte[] primBytes)
    {
        this.primBytes = primBytes;
    }

    public long[] getPrimLongs()
    {
        return primLongs;
    }

    public void setPrimLongs(long[] primLongs)
    {
        this.primLongs = primLongs;
    }

    public float[] getPrimFloats()
    {
        return primFloats;
    }

    public void setPrimFloats(float[] primFloats)
    {
        this.primFloats = primFloats;
    }

    //-- arrays - ojbects

    public Integer[] getDefaultObjIntegers()
    {
        return defaultObjIntegers;
    }

    public Double[] getDefaultObjDoubles()
    {
        return defaultObjDoubles;
    }

    public Short[] getDefaultObjShorts()
    {
        return defaultObjShorts;
    }

    public Byte[] getDefaultObjBytes()
    {
        return defaultObjBytes;
    }

    public Long[] getDefaultObjLongs()
    {
        return defaultObjLongs;
    }

    public Float[] getDefaultObjFloats()
    {
        return defaultObjFloats;
    }

    public Integer[] getObjIntegers()
    {
        return objIntegers;
    }

    public void setObjIntegers(Integer[] objIntegers)
    {
        this.objIntegers = objIntegers;
    }

    public Double[] getObjDoubles()
    {
        return objDoubles;
    }

    public void setObjDoubles(Double[] objDoubles)
    {
        this.objDoubles = objDoubles;
    }

    public Short[] getObjShorts()
    {
        return objShorts;
    }

    public void setObjShorts(Short[] objShorts)
    {
        this.objShorts = objShorts;
    }

    public Byte[] getObjBytes()
    {
        return objBytes;
    }

    public void setObjBytes(Byte[] objBytes)
    {
        this.objBytes = objBytes;
    }

    public Long[] getObjLongs()
    {
        return objLongs;
    }

    public void setObjLongs(Long[] objLongs)
    {
        this.objLongs = objLongs;
    }

    public Float[] getObjFloats()
    {
        return objFloats;
    }

    public void setObjFloats(Float[] objFloats)
    {
        this.objFloats = objFloats;
    }

    ///////////////////////////

    public int getPrimInt()
    {
        return primInt;
    }

    public void setPrimInt(int primInt)
    {
        this.primInt = primInt;
    }

    public double getPrimDouble()
    {
        return primDouble;
    }

    public void setPrimDouble(double primDouble)
    {
        this.primDouble = primDouble;
    }

    public short getPrimShort()
    {
        return primShort;
    }

    public void setPrimShort(short primShort)
    {
        this.primShort = primShort;
    }

    public byte getPrimByte()
    {
        return primByte;
    }

    public void setPrimByte(byte primByte)
    {
        this.primByte = primByte;
    }

    public long getPrimLong()
    {
        return primLong;
    }

    public void setPrimLong(long primLong)
    {
        this.primLong = primLong;
    }

    public float getPrimFloat()
    {
        return primFloat;
    }

    public void setPrimFloat(float primFloat)
    {
        this.primFloat = primFloat;
    }

    public boolean isPrimBoolean()
    {
        return primBoolean;
    }

    public void setPrimBoolean(boolean primBoolean)
    {
        this.primBoolean = primBoolean;
    }

    public Integer getObjInt()
    {
        return objInt;
    }

    public void setObjInt(Integer objInt)
    {
        this.objInt = objInt;
    }

    public Double getObjDouble()
    {
        return objDouble;
    }

    public void setObjDouble(Double objDouble)
    {
        this.objDouble = objDouble;
    }

    public Short getObjShort()
    {
        return objShort;
    }

    public void setObjShort(Short objShort)
    {
        this.objShort = objShort;
    }

    public Byte getObjByte()
    {
        return objByte;
    }

    public void setObjByte(Byte objByte)
    {
        this.objByte = objByte;
    }

    public Long getObjLong()
    {
        return objLong;
    }

    public void setObjLong(Long objLong)
    {
        this.objLong = objLong;
    }

    public Float getObjFloat()
    {
        return objFloat;
    }

    public void setObjFloat(Float objFloat)
    {
        this.objFloat = objFloat;
    }

    public Boolean getObjBoolean()
    {
        return objBoolean;
    }

    public void setObjBoolean(Boolean objBoolean)
    {
        this.objBoolean = objBoolean;
    }

    public Date getObjDate()
    {
        return objDate;
    }

    public void setObjDate(Date objDate)
    {
        this.objDate = objDate;
    }

    // Action implementation -----------------------------------------
    protected void doValidation()
    {
    }

    protected String doExecute()
            throws Exception
    {
        // Process data
        return SUCCESS;
    }
}
