/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import java.util.Comparator;

/**
 * Sorters. Utility sorters for use with the "sort" tag.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.9 $
 * @see webwork.view.taglib.iterator.SortIteratorTag
 * @see SortIteratorFilter
 */
public class Sorter
{
    public Comparator getAscending()
    {
        return new Comparator()
        {
            public int compare(Object o1, Object o2)
            {
                if (o1 instanceof Comparable)
                {
                    return ((Comparable) o1).compareTo(o2);
                }
                else
                {
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    return s1.compareTo(s2);
                }
            }
        };
    }

    public Comparator getDescending()
    {
        return new Comparator()
        {
            public int compare(Object o1, Object o2)
            {
                if (o2 instanceof Comparable)
                {
                    return ((Comparable) o2).compareTo(o1);
                }
                else
                {
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    return s2.compareTo(s1);
                }
            }
        };
    }

    public Comparator getComparator(String anExpression, boolean ascending)
    {
        if (ascending)
        {
            return getAscending(anExpression);
        }
        else
        {
            return getDescending(anExpression);
        }
    }

    public Comparator getAscending(final String anExpression)
    {
        return new Comparator()
        {
            private ValueStack stack = new ValueStack();

            public int compare(Object o1, Object o2)
            {
                // Get value for first object
                stack.pushValue(o1);
                Object v1 = stack.findValue(anExpression);
                stack.popValue();

                // Get value for second object
                stack.pushValue(o2);
                Object v2 = stack.findValue(anExpression);
                stack.popValue();

                // Ensure non-null
                if (v1 == null)
                {
                    v1 = "";
                }
                if (v2 == null)
                {
                    v2 = "";
                }

                // Compare them
                if (v1 instanceof Comparable && v1.getClass().equals(v2.getClass()))
                {
                    return ((Comparable) v1).compareTo(v2);
                }
                else
                {
                    String s1 = v1.toString();
                    String s2 = v2.toString();
                    return s1.compareTo(s2);
                }
            }
        };
    }

    public Comparator getDescending(final String anExpression)
    {
        return new Comparator()
        {
            private ValueStack stack = new ValueStack();

            public int compare(Object o1, Object o2)
            {
                // Get value for first object
                stack.pushValue(o1);
                Object v1 = stack.findValue(anExpression);
                stack.popValue();

                // Get value for second object
                stack.pushValue(o2);
                Object v2 = stack.findValue(anExpression);
                stack.popValue();

                // Ensure non-null
                if (v1 == null)
                {
                    v1 = "";
                }
                if (v2 == null)
                {
                    v2 = "";
                }

                // Compare them
                if (v2 instanceof Comparable && v1.getClass().equals(v2.getClass()))
                {
                    return ((Comparable) v2).compareTo(v1);
                }
                else
                {
                    String s1 = v1.toString();
                    String s2 = v2.toString();
                    return s2.compareTo(s1);
                }
            }
        };
    }
}
