package webwork.util;

import webwork.config.Configuration;

/**
 * This class acts as a cache around webwork's encoding property
 */
public class Encoding
{
    private static String encoding;
    private static boolean encodingDefined = true;

    /**
     * Get the encoding specified by the property 'webwork.i18n.encoding' in webwork.properties, or return the default
     * platform encoding if not specified.
     * <p/>
     * Note that if the property is not initially defined, this will return the system default, even if the property is
     * later defined.  This is mainly for performance reasons.  Undefined properties throw exceptions, which are a
     * costly operation.
     * <p/>
     * If the property is initially defined, it is read every time, until is is undefined, and then the system default
     * is used.
     * <p/>
     * Why not cache it completely?  Some applications will wish to be able to dynamically set the encoding at runtime.
     *
     * @return The encoding to be used.
     */
    public static String getEncoding()
    {
        if (encodingDefined)
        {
            try
            {
                encoding = Configuration.getString("webwork.i18n.encoding");
            }
            catch (IllegalArgumentException e)
            {
                encoding = System.getProperty("file.encoding");
                encodingDefined = false;
            }
        }
        return encoding;

    }
}
