/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;


/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.1 $
 */
public class UserInfo
{

    String lastname;
    String firstname;

    String email;

    String username;
    String password;

    String fnr;

    String adress;
    String postcode;
    String city;

    boolean male = true;

    public UserInfo(UserRegistration ur)
    {
        this.lastname = ur.lastname;
        this.firstname = ur.firstname;
        this.email = ur.email;
        this.username = ur.username;
        this.password = ur.password;
        this.fnr = ur.fnr;
        this.adress = ur.adress;
        this.postcode = ur.postcode;
        this.city = ur.city;
        this.male = ur.male;
    }

    public UserInfo(String lastname, String firstname, String email, String username, String password, String fnr, String adress, String postcode, String city, boolean male)
    {
        this.lastname = lastname;
        this.firstname = firstname;
        this.email = email;
        this.username = username;
        this.password = password;
        this.fnr = fnr;
        this.adress = adress;
        this.postcode = postcode;
        this.city = city;
        this.male = male;
    }

    public String getLastname()
    {
        return lastname;
    }

    public void setLastname(String lastname)
    {
        this.lastname = lastname;
    }

    public String getFirstname()
    {
        return firstname;
    }

    public void setFirstname(String firstname)
    {
        this.firstname = firstname;
    }

    public String getUsername()
    {
        return username;
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getFnr()
    {
        return fnr;
    }

    public void setFnr(String fnr)
    {
        this.fnr = fnr;
    }

    public String getAdress()
    {
        return adress;
    }

    public void setAdress(String adress)
    {
        this.adress = adress;
    }

    public String getPostcode()
    {
        return postcode;
    }

    public void setPostcode(String postcode)
    {
        this.postcode = postcode;
    }

    public String getCity()
    {
        return city;
    }

    public void setCity(String city)
    {
        this.city = city;
    }

    public boolean getMale()
    {
        return male;
    }

    public void setMale(boolean male)
    {
        this.male = male;
    }

    public String getEmail()
    {
        return email;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }

    public UserInfo()
    {
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(firstname);
        sb.append("\t");
        sb.append(lastname);
        sb.append("\t");
        sb.append(email);
        sb.append("\t");
        sb.append(username);
        sb.append("\t");
        sb.append(password);
        sb.append("\t");
        sb.append(fnr);
        sb.append("\t");
        sb.append(adress);
        sb.append("\t");
        sb.append(city);
        sb.append("\t");
        sb.append(postcode);
        sb.append("\t");
        sb.append(new Boolean(male).toString());

        return sb.toString();
    }

}
