/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.helloworld;

import webwork.action.ActionSupport;
import webwork.action.CommandDriven;

/**
 * Hello World action. Generate greeting phrase.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.5 $
 */
public class HelloWorld
        extends ActionSupport
        implements CommandDriven
{
    // Attributes ----------------------------------------------------
    String phrase = "";
    String name = "";

    String greeting;

    // Public --------------------------------------------------------
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }

    public void setPhrase(String phrase)
    {
        this.phrase = phrase;
    }

    public String getPhrase()
    {
        return phrase;
    }

    public String getGreeting()
    {
        return greeting;
    }

    // Action implementation ----------------------------------------
    protected void doValidation()
    {
        if (phrase.equals(""))
        {
            addError("phrase", "Missing greeting");
        }
        if (name.equals(""))
        {
            addError("name", "Missing name");
        }
    }

    protected String doExecute()
    {
        // Compute greeting
        greeting = phrase + " " + name;

        // Show result
        return SUCCESS;
    }
}
