/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.ParameterAware;

import java.util.*;

/**
 * Test action for XSLT view layer.
 *
 * @author Philipp Meier (meier@o-matic.de)
 * @version $Revision: 1.6 $
 * @see webwork.view.xslt.XSLTServlet
 */
public class XSLTTest extends ActionSupport implements ParameterAware
{
    // Attributes ----------------------------------------------------
    // Primitives
    boolean b;
    char c;
    int i;
    short s;
    long l;
    double d;
    float f;
    // Primitives' Classes
    Boolean bc;
    Character cc;
    Integer ic;
    Short sc;
    Long lc;
    Double dc;
    Float fc;
    // Containers;
    int[] iarray;
    Collection collection;
    Map map;
    Vector vector;
    // Beans (class declared below)
    TestBean testBean;

    // ParameterAware implementation
    Map parameters;

    // Property acces methods
    public boolean getB()
    { return this.b; }

    public char getC() { return this.c; }

    public int getI() { return this.i; }

    public short getS() { return this.s; }

    public long getL() { return this.l; }

    public double getD() { return this.d; }

    public float getF() { return this.f; }

    public Boolean getBC() { return this.bc; }

    public Character getCC() { return this.cc; }

    public Integer getIC() { return this.ic; }

    public Short getSC() { return this.sc; }

    public Long getLC() { return this.lc; }

    public Double getDC() { return this.dc; }

    public Float getFC() { return this.fc; }

    public int[] getIArray() { return this.iarray; }

    public Collection getCollection() { return this.collection; }

    public Map getMap() { return this.map; }

    public Vector getVector() { return this.vector; }

    public TestBean getTestBean() { return this.testBean; }


    // ParameterAware implementation ---------------------------------
    public void setParameters(Map parameters)
    {
        this.parameters = parameters;
    }

    // Action implementation -----------------------------------------
    protected String doExecute() throws Exception
    {
        b = true;
        c = 'c';
        i = 42;
        s = 42;
        l = 42l;
        d = 42.42d;
        f = 42.42f;

        bc = new Boolean(b);
        cc = new Character(c);
        ic = new Integer(i);
        sc = new Short(s);
        lc = new Long(l);
        dc = new Double(d);
        fc = new Float(f);

        iarray = new int[] { -2, -1, 0, 1, 2 };
        collection = new ArrayList();
        collection.add("First");
        collection.add("Second");
        collection.add("Third");
        collection.add("Fourth");
        collection.add("Last");

        map = new HashMap();
        map.put(new Integer(1), "First");
        map.put(new Short((short) 2), "Second");
        map.put(new Double(3), "Third");

        vector = new Vector();
        vector.add("x");
        vector.add("y");
        vector.add("z");

        testBean = new TestBean(new TestBean(new TestBean("Last", 3), 2), 1);

        return SUCCESS;
    }

    // Inner classes -------------------------------------------------
    public class TestBean
    {
        private Object foo;
        private int bar;

        public TestBean(Object foo, int bar)
        {
            this.foo = foo;
            this.bar = bar;
        }

        public Object getFoo()
        {
            return foo;
        }

        public int getBar()
        {
            return bar;
        }
    }
}
