/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.tagext.Tag;

/**
 * This class contains utility methods that are used by most of the tags. These methods can also be used by other code
 * that wants to access this type of functionality, such as Java code in JSP's.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.1 $
 */
public abstract class TagUtil
{
    // Static --------------------------------------------------------
    public static Tag findTagWithClass(Tag current, Class cl)
    {
        Tag p = current.getParent();
        while (p != null)
        {
            if (cl.isAssignableFrom(p.getClass()))
            {
                return p;
            }

            p = p.getParent();
        }

        return null;
    }
}


