/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.JspException;

/**
 * This tag can be used to parameterize other tags, who implement the ParametricTag interface declared here.
 * <p/>
 * The IncludeTag and BeanTag are examples of such tags.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.7 $
 * @see IncludeTag
 * @see BeanTag
 */
public class ParamTag
        extends WebWorkBodyTagSupport
{
    // Attributes ----------------------------------------------------
    protected String nameAttr;
    protected String valueAttr;

    public void setName(String aName)
    {
        nameAttr = aName;
    }

    public void setValue(String aName)
    {
        valueAttr = aName;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag() throws JspException
    {
        Parametric parametricTag = (Parametric) TagUtil.findTagWithClass(this, Parametric.class);
        if (parametricTag != null)
        {
            if (valueAttr != null)
            {
                if (parametricTag instanceof UnnamedParametric)
                {
                    ((UnnamedParametric) parametricTag).addParameter(findValue(valueAttr));
                }
                else
                {
                    Object name = findValue(nameAttr);

                    if (name == null)
                    {
                        throw new JspException("No name found for following expression:" + nameAttr);
                    }

                    Object value = findValue(valueAttr);
                    parametricTag.addParameter(name.toString(), value);
                }
            }
            else
            {
                String content;
                if (!(bodyContent != null && (content = bodyContent.getString()).length() != 0))
                {
                    content = null; // No value
                }

                if (parametricTag instanceof UnnamedParametric)
                {
                    ((UnnamedParametric) parametricTag).addParameter(content);
                }
                else
                {
                    parametricTag.addParameter(this.findString(nameAttr), content);
                }
            }
        }
        return EVAL_PAGE;
    }

    // Inner classes -------------------------------------------------
    public interface Parametric
    {
        public void addParameter(String name, Object value);
    }

    public interface UnnamedParametric
            extends Parametric
    {
        public void addParameter(Object value);
    }
}


