/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 1.9 $
 */
public class ElseIfTag
        extends WebWorkTagSupport
{
    // Attributes ----------------------------------------------------
    protected String test;
    protected boolean answer;

    // Public --------------------------------------------------------
    /**
     * Set the test condition.
     *
     * @param str
     */
    public void setTest(String str)
    {
        test = str;
    }

    // BodyTag implementation ---------------------------------------
    public int doStartTag() throws JspException
    {
        Boolean ifResult = getId() == null ?
                (Boolean) pageContext.getAttribute(IfTag.ANSWER) :
                (Boolean) pageContext.getAttribute(getId());

        if (ifResult == null || ifResult.booleanValue() == true)
        {
            return SKIP_BODY;
        }
        answer = getStack().test(test);
        // Make comparison
        if (answer)
        {
            return EVAL_BODY_INCLUDE;
        }
        else
        {
            return SKIP_BODY;
        }
    }

    public int doEndTag() throws JspException
    {
        if (answer)
        {
            if (getId() != null)
            {
                pageContext.setAttribute(getId(), new Boolean(answer));
            }

            pageContext.setAttribute(IfTag.ANSWER, new Boolean(answer));
        }
        answer = false;
        super.doEndTag();
        return EVAL_PAGE;
    }

    public void setParent(Tag t)
    {
        super.setParent(t);

        // Reset
        //test = null;
        //answer = false;
    }

    public void release()
    {
        setId(null);
        super.release();
    }
}



