/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

import webwork.action.ValidationEditorSupport;
import webwork.action.ActionContext;
import webwork.util.DateFormatter;

import java.text.DateFormat;
import java.util.Locale;
import java.util.Date;

/**
 * @author Matt Baldree (matt@smallleap.com)
 * @version $Revision: 1.6 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 * @see FastPropertyEditor
 * @see PropertyEditorException
 */
public class DateEditor extends ValidationEditorSupport implements FastPropertyEditor
{

    public void setAsText(String txt)
    {
        setValue(getAsValue(txt));
    }

    public Object getAsValue(String txt)
    {
        if (txt == null || txt.length() == 0)
        {
            return null;
        }
        try
        {
            DateFormatter formatter = new DateFormatter();
            try
            {
                formatter.setParser(DateFormat.getDateInstance(DateFormat.SHORT,
                        ActionContext.getLocale()));
            }
            catch (Exception e)
            {
                //ignore, use default parser
            }

            formatter.setDate(txt);
            return formatter.getDate();
        }
        catch (Exception e)
        {
            throw new PropertyEditorException(PropertyMessage.BAD_DATE, txt);
        }
    }

    public String getAsText()
    {
        return value == null ? "" : formatDate(value);
    }

    public String getAsText(Object val)
    {
        return val == null ? "" : formatDate(val);
    }

    private static String formatDate(Object obj)
    {
        try
        {
            DateFormatter formatter = new DateFormatter();
            formatter.setDate((Date) obj);

            try
            {
                formatter.setFormat(DateFormat.getDateInstance(DateFormat.SHORT,
                        ActionContext.getLocale()));
            }
            catch (Exception e)
            {
                //ignore, use default parser
            }
            return formatter.getFormattedDate();
        }
        catch (Exception e)
        {
            return "";
        }
    }

}

