package webwork.interceptor;

import webwork.action.Action;

/**
 * Defines the contract for an interceptor to hook into the lifecycle of an action.
 *
 * @since v4.2
 */
public interface Interceptor
{
    /**
     * The intercept method of the Interceptor is called by the dispatcher when an action is passed through the chain.
     * The InterceptorChain passed in to this method allows the Interceptor to pass on to the next entity in the chain.
     *
     * @param chain the interceptor chain that contains the next interceptor and the ultimate action
     * @return the result of the execution
     * @throws Exception if something goes wrong
     */
    String intercept(InterceptorChain chain) throws Exception;
}
