/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.events;

import webwork.action.ValidationEditorSupport;

/**
 * This code is an adaptation of the EventHandler example from the Rocks homepage by Christian Cryder
 * http://xmlc.enhydra.org/EventHandler/
 */
public class NameEditor
        extends ValidationEditorSupport
{
    public void setAsText(String txt)
    {
        // Validate name
        if (txt.length() > 30)
        {
            throw new IllegalArgumentException("Maximum of 30 alphabetic characters");
        }

        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Name must be specified");
        }

        if (txt.equals("santa"))
        {
            throw new IllegalArgumentException("So, you're Santa? Right..");
        }

        setValue(txt);
    }
}