/*
 * Decompiled with CFR 0.152.
 */
package webwork.config.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import webwork.config.Configuration;
import webwork.config.util.ActionInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigurationReader {
    public static final Log log = LogFactory.getLog(XMLConfigurationReader.class);
    private final Map<String, Object> actionMappings;
    private static final String EXTENSION_PROPERTY = "webwork.action.extension";
    private static final String DOT_ACTION_INFO_SUFFIX = ".actionInfo";
    private static final String DOT_ACTION_SUFFIX = ".action";

    public XMLConfigurationReader(Element configurationRootElement) {
        this.actionMappings = this.getMappingsFromDocument(configurationRootElement);
    }

    public Object getActionMapping(String mappingName) {
        String key = this.replaceExtension(mappingName);
        return this.actionMappings.get(key);
    }

    public Set getActionMappingNames() {
        return this.actionMappings.keySet();
    }

    private Map<String, Object> getMappingsFromDocument(Element element) {
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        NodeList actions = element.getElementsByTagName("action");
        int length = actions.getLength();
        for (int i = 0; i < length; ++i) {
            Element actionE = (Element)actions.item(i);
            String actionName = actionE.getAttribute("name");
            String actionAlias = actionE.getAttribute("alias");
            this.buildActionMapping(actionMap, actionE, actionName, actionAlias);
            this.buildViewMappings(actionMap, actionE, actionName, actionAlias);
            this.buildCommandMappings(actionMap, actionE, actionName, actionAlias);
        }
        return actionMap;
    }

    private void buildActionMapping(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias) {
        if (!"".equals(actionAlias)) {
            String magicActionKey = actionAlias + DOT_ACTION_SUFFIX;
            log.debug((Object)("Adding action alias " + actionAlias + "=" + actionName));
            actionMap.put(magicActionKey, actionName);
        }
        this.buildActionInfoMapping(actionMap, actionE, actionName, actionAlias);
    }

    private void buildViewMappings(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias) {
        Element view;
        NodeList views = actionE.getElementsByTagName("view");
        for (int j = 0; j < views.getLength() && (view = (Element)views.item(j)).getParentNode().equals(actionE); ++j) {
            NodeList viewMapping = view.getChildNodes();
            StringBuilder mapping = new StringBuilder();
            for (int k = 0; k < viewMapping.getLength(); ++k) {
                Node mappingNode = viewMapping.item(k);
                if (!(mappingNode instanceof Text)) continue;
                mapping.append(mappingNode.getNodeValue());
            }
            String actionViewName = "".equals(actionAlias) ? (!"".equals(actionName) ? actionName + "." + view.getAttribute("name") : view.getAttribute("name")) : actionAlias + "." + view.getAttribute("name");
            String actionViewMapping = mapping.toString().trim();
            log.debug((Object)("Adding view mapping " + actionViewName + "=" + actionViewMapping));
            actionMap.put(actionViewName, actionViewMapping);
        }
    }

    private void buildCommandMappings(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias) {
        NodeList commands = actionE.getElementsByTagName("command");
        for (int j = 0; j < commands.getLength(); ++j) {
            Element commandE = (Element)commands.item(j);
            String commandName = commandE.getAttribute("name");
            String commandAlias = commandE.getAttribute("alias");
            if (!commandAlias.equals("")) {
                String magicCommandAliasKey = commandAlias + DOT_ACTION_SUFFIX;
                log.debug((Object)("Adding command alias " + commandAlias + "=" + actionName + "!" + commandName));
                actionMap.put(magicCommandAliasKey, actionName + "!" + commandName);
            }
            this.buildActionInfoMapping(actionMap, commandE, commandName, commandAlias);
            NodeList views = commandE.getElementsByTagName("view");
            for (int k = 0; k < views.getLength(); ++k) {
                Element view = (Element)views.item(k);
                NodeList viewMapping = view.getChildNodes();
                StringBuilder mapping = new StringBuilder();
                for (int l = 0; l < viewMapping.getLength(); ++l) {
                    Node mappingNode = viewMapping.item(l);
                    if (!(mappingNode instanceof Text)) continue;
                    mapping.append(mappingNode.getNodeValue());
                }
                String commandViewName = commandAlias.equals("") ? (actionAlias.equals("") ? actionName + "!" + commandName + "." + view.getAttribute("name") : actionAlias + "!" + commandName + "." + view.getAttribute("name")) : commandAlias + "." + view.getAttribute("name");
                String commandViewMapping = mapping.toString().trim();
                log.debug((Object)("Adding command view mapping " + commandViewName + "=" + commandViewMapping));
                actionMap.put(commandViewName, commandViewMapping);
            }
        }
    }

    private void buildActionInfoMapping(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias) {
        List<Node> attributes = this.findAttributes(actionE);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Node attribute : attributes) {
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        ActionInfoImpl actionInfo = new ActionInfoImpl(actionName, actionAlias, attributeMap);
        String actionPrefix = actionAlias;
        if ("".equals(actionAlias)) {
            actionPrefix = actionName;
        }
        String magicActionInfoKey = actionPrefix + DOT_ACTION_INFO_SUFFIX;
        actionMap.put(magicActionInfoKey, actionInfo);
    }

    private List<Node> findAttributes(Element actionE) {
        ArrayList<Node> attributes = new ArrayList<Node>();
        NamedNodeMap nodeList = actionE.getAttributes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 2) continue;
            attributes.add(child);
        }
        return attributes;
    }

    private String replaceExtension(String actionName) {
        if (EXTENSION_PROPERTY.equals(actionName)) {
            return actionName;
        }
        String ext = "." + Configuration.get(EXTENSION_PROPERTY);
        if (actionName != null && !DOT_ACTION_SUFFIX.equals(ext)) {
            int idx;
            if (actionName.endsWith(ext)) {
                actionName = actionName.substring(0, actionName.lastIndexOf(ext)) + DOT_ACTION_SUFFIX;
            }
            if ((idx = actionName.indexOf(ext + "?")) > 0) {
                actionName = actionName.substring(0, idx) + ".action?" + actionName.substring(idx + ext.length() + 1);
            }
        }
        return actionName;
    }
}

