/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter.dom;

import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import webwork.view.xslt.SAXAdapter.AbstractWalker;
import webwork.view.xslt.SAXAdapter.XMLWalker;

import java.util.List;

public class TextWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value, String attributeName, List walkedInstances)
            throws SAXException
    {
        Text node = (Text) value;
        String characters = node.getNodeValue();
        contentHandler.characters(characters.toCharArray(), 0, characters.length());
    }

    public final Class getWalkedType()
    {
        return Text.class;
    }
}
