/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.util.List;

public class NullWalker extends AbstractWalker
{
    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value,
            String attributeName, List walkedInstances)
            throws SAXException
    {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "null", "", "CDATA", "true");
        contentHandler.startElement("", attributeName, "", attributes);
        contentHandler.endElement("", attributeName, "");
    }

    public final Class getWalkedType()
    {
        return String.class;
    }
}
