/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.velocity;

import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;
import org.apache.commons.logging.*;
import webwork.action.ServletActionContext;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletException;
import java.io.IOException;

/**
 * Velocity integration servlet. Transfer action properties to Velocity context and use WebWork configuration to supply
 * Velocity with settings.
 * <p/>
 * This allows you to use Velocity templates as views of WebWork actions.
 *
 * @author Rickard Őberg (rickard@dreambean.com)
 * @version $Revision: 1.7 $
 */
public class WebWorkVelocityServlet extends VelocityServlet
{
    protected static final String CONTEXT = "velocity_context";
    protected static final String WEBWORK_UTIL = "webwork";

    protected Log log = LogFactory.getLog(getClass());

    public void init() throws ServletException
    {
        try
        {
            VelocityHelper.initVelocity(getServletContext());
        }
        catch (Exception e)
        {
            throw new ServletException(e);
        }
    }

    public void service(ServletRequest aRequest, ServletResponse aResponse) throws ServletException, IOException
    {
        long start = 0;
        if (log.isDebugEnabled())
        {
            start = System.currentTimeMillis();
        }

        super.service(aRequest, aResponse);

        if (log.isDebugEnabled())
        {
            log.debug("Time:" + (System.currentTimeMillis() - start));
        }
    }

    /**
     * Create a context that delegates to the standard context and also allows Velocity to access properties from the
     * ValueStack.
     */
    protected Context createContext(javax.servlet.http.HttpServletRequest request,
            javax.servlet.http.HttpServletResponse response)
    {
        return VelocityHelper.getContext(getServletContext(), request, response);
    }

    /**
     * Get the template to show.
     */
    protected Template handleRequest(javax.servlet.http.HttpServletRequest aRequest,
            javax.servlet.http.HttpServletResponse aResponse,
            Context ctx)
            throws java.lang.Exception
    {
        // Bind standard WebWork utility into context

        ServletActionContext.setContext(aRequest, aResponse, getServletContext(), null);
        ctx.put(WEBWORK_UTIL, new WebWorkUtil(ctx));

        String servletPath = (String) aRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null)
        {
            servletPath = aRequest.getServletPath();
        }
        return getTemplate(servletPath);
    }
}
