/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * Text area tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class TextAreaTag extends AbstractHTMLComponentTag
{
    // Attributes ----------------------------------------------------
    protected String readonlyAttr;
    protected String onkeyupAttr;
    protected String cols;
    protected String rows;
    protected String sizeAttr;

    // Public --------------------------------------------------------
    public String getTemplate()
    {
        return "textarea";
    }

    public void setCols(String aSize)
    {
        this.cols = aSize;
    }

    public void setRows(String aSize)
    {
        this.rows = aSize;
    }

    public void setReadonly(String readonly)
    {
        this.readonlyAttr = readonly;
    }

    public void setOnkeyup(String onkeyup)
    {
        this.onkeyupAttr = onkeyup;
    }

    public void setSize(String aSize)
    {
        this.sizeAttr = aSize;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (cols != null)
        {
            this.addParameter("cols", findValue(cols));
        }
        if (rows != null)
        {
            this.addParameter("rows", findValue(rows));
        }
        if (readonlyAttr != null)
        {
            this.addParameter("readonly", findValue(readonlyAttr));
        }
        if (onkeyupAttr != null)
        {
            this.addParameter("onkeyup", findValue(onkeyupAttr));
        }
        if (sizeAttr != null)
        {
            this.addParameter("size", findValue(sizeAttr));
        }
        return super.doEndTag();
    }
}

