package webwork.view.taglib.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import webwork.config.Configuration;
import webwork.util.BeanUtil;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;
import webwork.view.velocity.VelocityHelper;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import java.util.HashMap;
import java.util.Map;

/**
 * Base class for UI HTML Fragments
 *
 * @since 4.3
 */
public class FragmentTag
        extends WebWorkBodyTagSupport
        implements ParamTag.Parametric
{
    // Attributes ----------------------------------------------------
    protected static Log log = LogFactory.getLog(FragmentTag.class);
    protected String themeAttr;
    protected String templateAttr;
    protected String templateSuffix;
    protected String theme;
    protected Map params = new HashMap();
    protected String templateDir;

    // Public --------------------------------------------------------

    public String getTemplate()
    {
        // Should never get here, but if we do, then just show something
        return "text";
    }

    public String getTheme()
    {
        // If theme set is not explicitly given,
        // try to find attribute which states the theme set to use
        if ((theme == null) || (theme == ""))
        {
            theme = (String) pageContext.findAttribute("theme");
        }

        // Default template set
        if ((theme == null) || (theme == ""))
        {
            theme = Configuration.getString("webwork.ui.theme");
        }

        return theme;
    }

    public String getTemplateSuffix()
    {
        if (templateSuffix == null || templateSuffix == "")
        {
            templateSuffix = Configuration.getString("webwork.ui.templateSuffix");
        }
        return templateSuffix;
    }

    public String getTemplateDir()
    {
        // If templateDir is not explicitly given,
        // try to find attribute which states the dir set to use
        if ((templateDir == null) || (templateDir == ""))
        {
            templateDir = (String) pageContext.findAttribute("templateDir");
        }

        // Default template set
        if ((templateDir == null) || (templateDir == ""))
        {
            templateDir = Configuration.getString("webwork.ui.templateDir");
        }

        if ((templateDir == null) || (templateDir == ""))
        {
            templateDir = "template";
        }

        return templateDir;
    }

    public void setTheme(String aName)
    {
        themeAttr = aName;
    }

    public void setTemplate(String aName)
    {
        templateAttr = aName;
    }

    public void addParameter(String name, Object value)
    {
        addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value)
    {
        params.put(name, value);
    }

    public Map getParameters()
    {
        return params;
    }

    public boolean memberOf(Object obj1, Object obj2)
    {
        return ContainUtil.contains(obj1, obj2);
    }

    // IncludeTag overrides ------------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (themeAttr != null)
        {
            theme = (String) findValue(themeAttr);
        }

        // Get name of JSP fragment
        String template = templateAttr;
        if (template == null)
        {
            template = getTemplate() + "." + getTemplateSuffix();
        }

        getStack().pushValue(this);

        try
        {
            String templatePath = "/" + getTemplateDir() + "/" + getTheme() + "/" + template;
            if (log.isDebugEnabled())
            {
                log.debug("Using template:" + templatePath);
            }
            if (templatePath.endsWith(".vm"))
            {
                Context c = VelocityHelper.getContext(pageContext.getServletContext(), pageContext.getRequest(), pageContext.getResponse());
                VelocityHelper.merge(c, templatePath, pageContext.getOut());
            }
            else
            {
                IncludeTag.include(templatePath, pageContext);
            }
            return EVAL_PAGE;
        }
        catch (Exception e)
        {
            throw new JspTagException("Including component failed:" + toString(e));
        }
        finally
        {
            getStack().popValue();
            params = new HashMap();
        }
    }

}
