/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

/**
 * The iterator tag can export an IteratorStatus object so that one can get information about the status of the
 * iteration, such as the size, current index, and whether any more items are available.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 */
public class IteratorStatus
{
    // Attributes ----------------------------------------------------
    protected StatusState state;

    // Static --------------------------------------------------------

    // Constructors --------------------------------------------------

    public IteratorStatus(StatusState aState)
    {
        state = aState;
    }

    // Public --------------------------------------------------------
    public boolean isFirst()
    {
        return state.index == 0;
    }

    public boolean isLast()
    {
        return state.last;
    }

    public int getCount()
    {
        return state.index + 1;
    }

    public int getIndex()
    {
        return state.index;
    }

    public boolean isOdd()
    {
        return ((state.index + 1) % 2) == 1;
    }

    public boolean isEven()
    {
        return ((state.index + 1) % 2) == 0;
    }

    public int modulus(int operand)
    {
        return (state.index + 1) % operand;
    }


    // Package protected ---------------------------------------------

    // Protected -----------------------------------------------------

    // Private -------------------------------------------------------

    // Inner classes -------------------------------------------------

    public static class StatusState
    {
        int index = 0;
        boolean last = false;

        public void setLast(boolean isLast)
        {
            last = isLast;
        }

        public void next()
        {
            index++;
        }
    }
}
