package webwork.util.injection;

import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;
import webwork.util.InjectionUtils;

import java.io.IOException;

public class ObjectFactory
{
    private static ObjectCreator impl;
    public static final String CLASS_NAME = "webwork.injection.objectcreator";

    static
    {
        impl = new DefaultObjectCreator();

        try
        {
            String classname = (String) Configuration.get(CLASS_NAME);
            if (classname != null && classname.length() > 0)
            {
                try
                {
                    impl = (ObjectCreator) ClassLoaderUtils.loadClass(classname, ObjectCreator.class).newInstance();
                }
                catch (Exception e)
                {
                    LogFactory.getLog(InjectionUtils.class).error("Could not load class " + classname + " or could not cast it to InjectionUtils.  Using default", e);
                }
            }
        }
        catch (IllegalArgumentException e)
        {
            //do nothing - this is just because the property couldn't be found.
        }
        catch (LogConfigurationException e)
        {
            //just catching this to be safe.
        }
    }

    public static Object instantiate(Class actionClass) throws IllegalAccessException, InstantiationException
    {
        return impl.instantiate(actionClass);
    }

    public static Object instantiateBean(ClassLoader classloader, String className)
            throws IOException, ClassNotFoundException
    {
        return impl.instantiateBean(classloader, className);
    }

}
