package webwork.util.injection;

import java.io.IOException;

public class DefaultObjectCreator implements ObjectCreator
{
    public Object instantiate(Class clazz) throws IllegalAccessException, InstantiationException
    {
        return clazz.newInstance();
    }

    public Object instantiateBean(ClassLoader classloader, String className) throws IOException, ClassNotFoundException
    {
        //this is too slow, and you'd have to be pretty crazy to need the .ser support, so we just instantiate directly
        //return Beans.instantiate(classloader, className);
        Class c = classloader == null ? Class.forName(className) : classloader.loadClass(className);
        try
        {
            return c.newInstance();
        }
        catch (Exception ex)
        {
            throw new ClassNotFoundException(c + " : " + ex, ex);
        }
    }
}
