package webwork.util.classloader;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import webwork.util.ClassLoaderUtils;

/**
 * User: Hani Suleiman Date: Oct 22, 2003 Time: 3:57:08 PM
 */
public class DirectoryClassLoader extends WebworkClassLoader
{
    private File directory;
    private HashMap timestamps = new HashMap();

    public DirectoryClassLoader(File file, ClassLoader parent)
    {
        super(parent);
        this.directory = file;
    }

    public boolean isStale()
    {
        Iterator iter = ((Map) timestamps.clone()).entrySet().iterator();
        while (iter.hasNext())
        {
            Map.Entry entry = (Map.Entry) iter.next();
            File toCheck = (File) entry.getKey();
            long time = ((Long) entry.getValue()).longValue();
            if (toCheck.lastModified() > time)
            {
                return true;
            }
        }
        return false;
    }

    protected URL getDataURL(String name, byte[] data) throws MalformedURLException
    {
        return new URL(null, directory.toURL().toExternalForm() + '/' + name, new BytesURLStreamHandler(data));
    }

    public byte[] getFile(String path)
    {
        try
        {
            File file = new File(directory, path);
            if (!file.exists())
            {
                return null;
            }
            int size = (int) file.length();
            InputStream in = new FileInputStream(file);
            //we're ok not storing timestamps for jars, since the whole jar
            //will be modified in that case.
            timestamps.put(file, new Long(file.lastModified()));
            return ClassLoaderUtils.readStream(in, size);
        }
        catch (IOException e)
        {
            return null;
        }
    }

    public Object clone()
    {
        DirectoryClassLoader loader = new DirectoryClassLoader(directory, getParent());
        loader.packages = packages;
        return loader;
    }
}
