/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import org.apache.commons.logging.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Comparator;
import java.util.List;
import java.util.Collections;

/**
 * A bean that takes an iterator and outputs a subset of it.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.9 $
 * @see <related>
 */
public class SortIteratorFilter
        extends IteratorFilterSupport
        implements Iterator, webwork.action.Action
{
    // Attributes ----------------------------------------------------
    Object source;
    Comparator comparator;
    Iterator iterator;
    List list;

    // Public --------------------------------------------------------
    public void setSource(Object anIterator)
    {
        source = anIterator;
    }

    public void setComparator(Comparator aComparator)
    {
        this.comparator = aComparator;
    }

    public List getList()
    {
        return list;
    }

    // Action implementation -----------------------------------------
    public String execute()
    {
        if (source == null)
        {
            return ERROR;
        }
        else
        {
            try
            {
                if (!MakeIterator.isIterable(source))
                {
                    LogFactory.getLog(SortIteratorFilter.class.getName()).warn("Cannot create SortIterator for source " + source);
                    return ERROR;
                }
                list = new ArrayList();
                Iterator i = MakeIterator.convert(source);
                while (i.hasNext())
                {
                    list.add(i.next());
                }
                // Sort it
                Collections.sort(list, comparator);
                iterator = list.iterator();

                return SUCCESS;
            }
            catch (Exception e)
            {
                LogFactory.getLog(SortIteratorFilter.class.getName()).warn("Error creating sort iterator.", e);
                return ERROR;
            }
        }
    }

    // Iterator implementation ---------------------------------------
    public boolean hasNext()
    {
        return (source == null) ? false : iterator.hasNext();
    }

    public Object next()
    {
        return iterator.next();
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Remove is not supported in SortIteratorFilter.");
    }
}
