/* Generated By:JavaCC: Do not edit this line. Parser.java */
package webwork.expr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import webwork.util.ValueStack;

/**
 *   The WebWork Expression language Parser and Interpreter.
 *
 *   @author Maurice C. Parker (maurice@vineyardenterprise.com)
 *   @version $Revision: 1.21 $
 */ public final class Parser implements ParserConstants {

   // Attributes ----------------------------------------------------
   private ValueStack valueStack;
   private int nestDepth = 0;
   protected static Log log = LogFactory.getLog(Parser.class);

   // Public --------------------------------------------------------
   /**
    * Set the value stack
    */
   public void setValueStack(ValueStack valueStack)
   {
      this.valueStack = valueStack;
   }

   // Private -------------------------------------------------------
   /**
    * This method moves the current token to the next matching
    * paren.  This is necessary when you want to end an evaluation
    * inside a nested "||" statement early.
    *
    */
   private void consume_remaining_or_tokens() {
      Token token;
      int nesting = 1;
      while (true) {
         token = getToken(1);
         if (token.kind == LPAREN) nesting++;
         if (token.kind == RPAREN) {
            nesting--;
            if (nesting == 0)
               break;
         }
         token = getNextToken();
      }
   }

   /**
    * This method moves the current token to the next matching
    * paren.  This is necessary when you want to end an evaluation
    * inside a nested "&&" statement early.
    *
    */
   private void consume_remaining_and_tokens() {
      Token token;
      int nesting = 1;
      while (true) {
         token = getToken(1);
         if (token.kind == OR) break;
         if (token.kind == LPAREN) nesting++;
         if (token.kind == RPAREN) {
            nesting--;
            if (nesting == 0)
               break;
         }
         token = getNextToken();
      }
   }

   /**
    * determine true or false by comparing the comparison result
    * with the operator.
    *
    * @param   comp  the comparison result
    * @param   operatr  the operator
    * @return     the boolean result
    *
    */
   private boolean resolve(int comp, Token operatr) {

      //log.debug( "comp: " + comp + ", operatr: " + operatr);
      if ( comp == 0 )
      {
         switch (operatr.kind) {
            case EQ:
            case GE:
            case LE:
               return true;
            default:
               return false;
         }
      }

      if ( comp > 0 )
      {
         switch (operatr.kind) {
            case GT:
            case GE:
            case NE:
               return true;
            default:
               return false;
         }
      }

      switch (operatr.kind) {
         case LT:
         case LE:
         case NE:
            return true;
      }

      return false;

   }

  final public boolean test() throws ParseException {
   boolean answer;
    answer = logical_and_expression();
      if ( answer == true ) {
         if ( nestDepth > 0 )
            consume_remaining_or_tokens();
         {if (true) return true;}
      }
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case OR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      answer = logical_and_expression();
         if ( answer == true ) {
            if ( nestDepth > 0 )
               consume_remaining_or_tokens();
            {if (true) return true;}
         }
    }
      {if (true) return false;}
    throw new Error("Missing return statement in function");
  }

  final public boolean logical_and_expression() throws ParseException {
   boolean answer;
    answer = comparative_expression();
      if ( answer == false ) {
         if ( nestDepth > 0 )
            consume_remaining_and_tokens();
         {if (true) return false;}
      }
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case AND:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      answer = comparative_expression();
         if ( answer == false ) {
            if ( nestDepth > 0 )
               consume_remaining_and_tokens();
            {if (true) return false;}
         }
    }
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public boolean comparative_expression() throws ParseException {
   Token token;
   Object operand1;
   Object operand2;
   boolean answer = false;
    switch (jj_nt.kind) {
    case LPAREN:
         nestDepth++;
      jj_consume_token(LPAREN);
      answer = test();
      jj_consume_token(RPAREN);
         nestDepth--;
      break;
    case 17:
      jj_consume_token(17);
      operand1 = findValue();
         if ( operand1 == null )
            {if (true) return true;}
         else
            {if (true) return false;}
      break;
    case ID:
      // Not null test
               operand1 = findValue();
            if ( operand1 != null )
               answer = true;
            else
               answer =  false;
      switch (jj_nt.kind) {
      case EQ:
      case NE:
      case GT:
      case GE:
      case LT:
      case LE:
        switch (jj_nt.kind) {
        case EQ:
          token = jj_consume_token(EQ);
          break;
        case NE:
          token = jj_consume_token(NE);
          break;
        case GT:
          token = jj_consume_token(GT);
          break;
        case GE:
          token = jj_consume_token(GE);
          break;
        case LT:
          token = jj_consume_token(LT);
          break;
        case LE:
          token = jj_consume_token(LE);
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        operand2 = findValue();
               // We resolve nulls by hand
               if ( operand1 == null || operand2 == null )
               {
                  int comp = -1; // less than
                  if ( operand1 == null && operand2 == null ) // equal to
                  {
                     comp = 0;
                  }
                  else if ( operand2 == null ) // greater than
                  {
                     comp = 1;
                  }
                  {if (true) return resolve(comp, token);}
               }

               if ( operand1 instanceof Number && operand2 instanceof Number ) {

                  double number1 = ((Number)operand1).doubleValue();
                  double number2 = ((Number)operand2).doubleValue();

                  int comp = -1; // less than
                  if ( number1 > number2 ) {
                     comp = 1;  // greater than
                  } else if ( number1 == number2 ) {
                     long longBits1 = Double.doubleToLongBits(number1);
                     long longBits2 = Double.doubleToLongBits(number2);
                     if ( longBits1 > longBits2 ) {
                        comp = 1;
                     } else if ( longBits1 == longBits2 ) {
                        comp = 0;
                     }
                  }

                  {if (true) return resolve(comp, token);}
               }

              // If operands are of the same type, do a direct comparison
              if ( operand1.getClass().equals(operand2.getClass()) ) {
                  if ( operand1 instanceof Comparable ) {
                      int comp = ((Comparable)operand1).compareTo(operand2);
                      {if (true) return resolve(comp, token);}
                  }
              }

              // If the operands aren't the same type or aren't comparible, then
              // convert them to strings and do a comparison
              // Mo: I think that this could lead to some difficult to predict or unpredictable behavior
              operand1 = operand1.toString();
              operand2 = operand2.toString();

              int comp = ((Comparable)operand1).compareTo(operand2);
              {if (true) return resolve(comp, token);}
        break;
      default:
        jj_la1[3] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return answer;}
    throw new Error("Missing return statement in function");
  }

  final public Object findValue() throws ParseException {
   Token token;
    /* Constants */
       token = jj_consume_token(ID);
      {if (true) return valueStack.findValue(token.image);}
    throw new Error("Missing return statement in function");
  }

  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_gen;
  final private int[] jj_la1 = new int[5];
  final private int[] jj_la1_0 = {0x10000,0x8000,0x7e00,0x7e00,0x200a0,};

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[18];
    for (int i = 0; i < 18; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 18; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
