/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;


import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;


/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.1 $
 * @see java.beans.SimpleBeanInfo
 */
public class UserRegistrationBeanInfo
        extends SimpleBeanInfo
{

    public PropertyDescriptor[] getPropertyDescriptors()
    {
        try
        {
            ArrayList list = new ArrayList();

            PropertyDescriptor descriptor;

            /** special validation trough property editors **/
            descriptor = new PropertyDescriptor("lastname", UserRegistration.class);
            descriptor.setPropertyEditorClass(NameEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("firstname", UserRegistration.class);
            descriptor.setPropertyEditorClass(NameEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("fnr", UserRegistration.class);
            descriptor.setPropertyEditorClass(SsnEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("username", UserRegistration.class);
            descriptor.setPropertyEditorClass(UsernameEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("password", UserRegistration.class);
            descriptor.setPropertyEditorClass(PasswordEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("confirmedPassword", UserRegistration.class);
            descriptor.setPropertyEditorClass(PasswordEditor.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("email", UserRegistration.class);
            descriptor.setPropertyEditorClass(EmailEditor.class);
            list.add(descriptor);

            /** normal validation not trough property editors **/
            descriptor = new PropertyDescriptor("city", UserRegistration.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("adress", UserRegistration.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("postcode", UserRegistration.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("male", UserRegistration.class);
            list.add(descriptor);
            descriptor = new PropertyDescriptor("netcheck", UserRegistration.class);
            list.add(descriptor);

            return (PropertyDescriptor[]) list.toArray(new PropertyDescriptor[list.size()]);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getPropertyDescriptors();
        }
    }

    public BeanInfo[] getAdditionalBeanInfo()
    {
        try
        {
            return new BeanInfo[] { Introspector.getBeanInfo(UserRegistration.class.getSuperclass()) };
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getAdditionalBeanInfo();
        }
    }

}