/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import webwork.action.ActionSupport;
import webwork.action.CommandDriven;
import webwork.action.ServletRequestAware;
import webwork.action.SessionAware;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.4 $
 * @see ActionSupport
 * @see ServletRequestAware
 * @see SessionAware
 * @see CommandDriven
 */
public class UserRegistration extends ActionSupport implements ServletRequestAware, SessionAware, CommandDriven
{

    HttpServletRequest req;
    Map session;

    String lastname;
    String firstname;

    String email;

    String username;
    String password;
    String confirmedPassword;

    String fnr;

    String adress;
    String postcode;
    String city;

    boolean male;

    boolean netcheck = false;

    public String getLastname()
    {
        return lastname;
    }

    public void setLastname(String lastname)
    {
        this.lastname = lastname;
    }

    public String getFirstname()
    {
        return firstname;
    }

    public void setFirstname(String firstname)
    {
        this.firstname = firstname;
    }

    public String getUsername()
    {
        return username;
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getConfirmedPassword()
    {
        return confirmedPassword;
    }

    public void setConfirmedPassword(String confirmedPassword)
    {
        this.confirmedPassword = confirmedPassword;
    }

    public String getFnr()
    {
        return fnr;
    }

    public void setFnr(String fnr)
    {
        this.fnr = fnr;
    }

    public String getAdress()
    {
        return adress;
    }

    public void setAdress(String adress)
    {
        this.adress = adress;
    }

    public String getPostcode()
    {
        return postcode;
    }

    public void setPostcode(String postcode)
    {
        this.postcode = postcode;
    }

    public String getCity()
    {
        return city;
    }

    public void setCity(String city)
    {
        this.city = city;
    }

    public boolean getMale()
    {
        return male;
    }

    public void setMale(boolean male)
    {
        this.male = male;
    }

    public String getEmail()
    {
        return email;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }

    public boolean getNetcheck()
    {
        return netcheck;
    }

    public void setNetcheck(boolean netcheck)
    {
        this.netcheck = netcheck;
    }

    // SessionAware implementation ------------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Public --------------------------------------------------------
    public void setServletRequest(HttpServletRequest request)
    {
        this.req = request;
    }

    protected String doExecute() throws Exception
    {

        String ctx = req.getContextPath();
        ctx = ctx.substring(ctx.indexOf('/') + 1);
        String path = req.getRealPath(req.getContextPath());
        path = path.substring(0, path.length() - ctx.length());
        path += "WEB-INF\\etc\\UserDatabase.yap";

        UserInfo querySample = new UserInfo();
        querySample.setUsername(this.username);

        ObjectContainer db = Db4o.openFile(path);
        ObjectSet set = db.get(querySample);

        UserInfo ui = null;
        while (set.hasNext())
        {
            ui = (UserInfo) set.next();
            db.activate(ui, 1);
            System.out.println(ui.toString());
        }

        if (ui != null && username.equals(ui.username))
        {
            addError("username", "Sorry. This username is already taken. Please try another");
            db.close();
            return ERROR;
        }
        else
        {
            db.set(new UserInfo(this));
        }

        db.close();
        return SUCCESS;
    }

    protected void doValidation()
    {

        if (!getHasErrors())
        {

            // check if passwords match
            if (!password.equals(confirmedPassword))
            {
                addError("password", "Passwords does not match");
                addError("confirmedPassword", "");
            }

            // check if the email is valid by checking the host name
            if (!Validator.checkEmail(this.email, this.netcheck))
            {
                addError("email", "This email does not have a valid hostname");
            }


            // check if the this SSN is valid for the gender given
            if (!Validator.checkSsnWithGenderCheck(fnr, male))
            {
                String msg = "This is not valid Norwegian social security number for a ";
                if (male)
                {
                    msg += "male";
                }
                else
                {
                    msg += "female";
                }

                addError("fnr", msg);
            }
        }
    }
}
