/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.userreg;

import webwork.action.ValidationEditorSupport;

/**
 * @author Kjetil H.Paulsen (kjetil@java.no)
 * @version $Revision: 1.3 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 */
public class PasswordEditor extends ValidationEditorSupport
{

    public void setAsText(String txt)
    {

        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Password must be given");
        }

        // Validate name
        if (txt.length() < 4)
        {
            throw new IllegalArgumentException("Password must be more than 4 characters");
        }


        setValue(txt);
    }
}

