/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.helloworld;

import webwork.action.ActionSupport;
import webwork.action.SessionAware;

import java.util.Map;

/**
 * Login status of user.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.5 $
 * @see <related>
 */
public class LoginStatus
        extends ActionSupport
        implements SessionAware
{
    // Attributes ----------------------------------------------------
    Map session;

    // Public --------------------------------------------------------
    public String getName()
    {
        return session.get("name") == null ? "Guest" : (String) session.get("name");
    }

    // SessionAware implementation -----------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Action implementation -----------------------------------------
    protected String doExecute()
    {
        return (session.get("name") == null) ? ERROR : SUCCESS;
    }
}
