/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.events;

import webwork.action.ActionSupport;
import webwork.action.SessionAware;

import java.util.Map;

/**
 * This code is an adaptation of the EventHandler example from the Rocks homepage by Christian Cryder
 * http://xmlc.enhydra.org/EventHandler/
 */
public class LoginCounter
        extends ActionSupport
        implements SessionAware
{
    // Attributes ----------------------------------------------------
    Map session;

    // Public --------------------------------------------------------
    public int getCount()
    {
        return ((Integer) session.get("count")).intValue();
    }

    // SessionAware implementation ------------------------------------
    public void setSession(Map session)
    {
        this.session = session;
    }

    // Action implementation ----------------------------------------
    protected String doExecute()
    {
        Integer count = (Integer) session.get("count");

        if (count == null)
        {
            count = new Integer(0);
        }

        count = new Integer(count.intValue() + 1);

        session.put("count", count);

        return SUCCESS;
    }
}
