/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.events;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;

/**
 * This code is an adaptation of the EventHandler example from the Rocks homepage by Christian Cryder
 * http://xmlc.enhydra.org/EventHandler/
 */
public class LoginBeanInfo
        extends SimpleBeanInfo
{
    // Public  -------------------------------------------------------

    public PropertyDescriptor[] getPropertyDescriptors()
    {
        try
        {
            ArrayList list = new ArrayList();

            PropertyDescriptor descriptor;

            descriptor = new PropertyDescriptor("name", Login.class);
            descriptor.setPropertyEditorClass(NameEditor.class);
            list.add(descriptor);

            descriptor = new PropertyDescriptor("password", Login.class);
            descriptor.setPropertyEditorClass(PasswordEditor.class);
            list.add(descriptor);

            descriptor = new PropertyDescriptor("autoLogin", Login.class, "getAutoLogin", null);
            list.add(descriptor);

            return (PropertyDescriptor[]) list.toArray(new PropertyDescriptor[list.size()]);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getPropertyDescriptors();
        }
    }

    public BeanInfo[] getAdditionalBeanInfo()
    {
        try
        {
            return new BeanInfo[] { Introspector.getBeanInfo(Login.class.getSuperclass()) };
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getAdditionalBeanInfo();
        }
    }

}