package webwork.examples;

import webwork.action.Action;
import webwork.action.ActionSupport;

public class Primes extends ActionSupport
{
    private int start = 1;
    private int end = 1000;
    private boolean[] primes;

    public void setStart(int start)
    {
        this.start = start;
    }

    public int getStart()
    {
        return start;
    }

    public void setEnd(int end)
    {
        this.end = end;
    }

    public int getEnd()
    {
        return end;
    }

    public boolean[] getPrimes()
    {
        return primes;
    }

    protected boolean isPrime(int number)
    {
        if (number == 1 || number % 2 == 0 && number > 2)
        {
            return false;
        }
        for (int i = 3; i < Math.sqrt(number); i += 2)
        {
            if (number % i == 0)
            {
                return false;
            }
        }
        return true;
    }

    protected String doExecute()
    {
        primes = new boolean[end - start + 1];
        for (int i = start; i <= end; i++)
        {
            primes[i - start] = isPrime(i);
        }
        return Action.SUCCESS;
    }
}


