/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.ParameterAware;
import webwork.util.BeanUtil;

import java.util.Map;

/**
 * A form which has two data objects.
 *
 * @author Rickard \u00D6berg (<email>)
 * @version $Revision: 1.4 $
 * @see <related>
 */
public class MultiForm
        extends ActionSupport
        implements ParameterAware
{
    // Constants -----------------------------------------------------

    // Attributes ----------------------------------------------------
    Foo foo = new Foo();
    Bar bar = new Bar();

    Map parameters;

    // Static --------------------------------------------------------

    // Constructors --------------------------------------------------

    // Public --------------------------------------------------------

    public Foo getFoo()
    {
        return foo;
    }

    public Bar getBar()
    {
        return bar;
    }

    // ParameterAware implementation ---------------------------------
    public void setParameters(Map params)
    {
        parameters = params;
    }

    // Action implementation -----------------------------------------
    protected String doExecute()
            throws Exception
    {
        // Get values for the objects
        BeanUtil.setProperties(parameters, foo);
        BeanUtil.setProperties(parameters, bar);

        // Validation
        if (foo.getX() < 0)
        {
            addErrorMessage("Foo.X may not be negative");
            foo = new Foo(); // Reset
        }
        if (bar.getY().equals("Bar"))
        {
            addErrorMessage("Bar is not a valid Y");
            bar.setY(""); // Reset
        }

        return SUCCESS;
    }

    // Private -------------------------------------------------------

    // Inner classes -------------------------------------------------

    public class Foo
    {
        int x = 42;

        public void setX(int x)
        {
            this.x = x;
        }

        public int getX()
        {
            return x;
        }
    }

    public class Bar
    {
        String y = "Xyzzy";

        public void setY(String y)
        {
            this.y = y;
        }

        public String getY()
        {
            return y;
        }
    }
}
