/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/**
 * A list of ages
 *
 * @author Rickard \u00D6berg (<email>)
 * @version $Revision: 1.4 $
 * @see <related>
 */
public class AgeList
        extends ActionSupport
{
    // Attributes ----------------------------------------------------
    static List ages;

    static
    {
        // This never changes, so we do it once only
        ages = new ArrayList();

        // We read the values from a file so that it is easy to change
        try
        {
            InputStream resource = AgeList.class.getResourceAsStream("ages.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(resource));
            String age;
            while ((age = in.readLine()) != null)
            {
                ages.add(age);
            }
            in.close();
        }
        catch (IOException e)
        {
            e.printStackTrace(System.err);
            System.err.println("Could not read list of ages");
            ages.add("0-100"); // Default so we at least get something
        }
    }

    // Public --------------------------------------------------------
    public List getAges()
    {
        return ages;
    }
}
