/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.factory;

import webwork.action.Action;
import webwork.action.PrepareAction;

import java.util.Map;

/**
 * Prepares or initializes an action implementing the {@link PrepareAction} interface after first locating it through
 * the action factory proxy chain.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.5 $
 */
public class PrepareActionFactoryProxy extends ActionFactoryProxy
{
    // Attributes ----------------------------------------------------
    Map applicationMap;

    // Constructors --------------------------------------------------
    public PrepareActionFactoryProxy(ActionFactory aFactory)
    {
        super(aFactory);
    }

    // ActionFactory implementation -------------------------------
    public Action getActionImpl(String aName)
            throws Exception
    {
        // Get action from factory
        Action action = getNextFactory().getActionImpl(aName);

        // Check if action wants to prepare itself
        if (action instanceof PrepareAction)
        {
            ((PrepareAction) action).prepare();
        }

        // Return action
        return action;
    }
}
