/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.factory;

import javax.servlet.ServletRequest;
import java.util.*;

/**
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.9 $
 */
public class ParameterMap extends AbstractMap
{
    ServletRequest request;
    Set entries;
    private static final String SESSION_ID_PREFIX = ";jsessionid=";

    public ParameterMap(ServletRequest request)
    {
        this.request = request;
    }

    public Set entrySet()
    {
        if (entries == null)
        {
            entries = new HashSet();

            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements())
            {
                final String key = e.nextElement().toString();
                final String[] value = request.getParameterValues(key);

                entries.add(new Map.Entry()
                {
                    public boolean equals(Object obj)
                    {
                        Map.Entry entry = (Map.Entry) obj;
                        return (key == null ?
                                entry.getKey() == null : key.equals(entry.getKey())) &&
                                (value == null ?
                                        entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode()
                    {
                        return (key == null ? 0 : key.hashCode()) ^
                                (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey()
                    {
                        return key;
                    }

                    public Object getValue()
                    {
                        return value;
                    }

                    public Object setValue(Object obj)
                    {
                        // Not allowed
                        throw new UnsupportedOperationException("Can't set parameter");
                    }
                });
            }
        }

        return entries;
    }

    public Object put(Object key, Object value)
    {
        // Not allowed
        throw new UnsupportedOperationException("Can't set parameter");
    }

    public Object get(Object key)
    {
        return request.getParameterValues(key.toString());
    }

    public Object remove(Object key)
    {
        // Not allowed
        throw new UnsupportedOperationException("Can't remove parameter");
    }

    public void clear()
    {
        // Not allowed
        throw new UnsupportedOperationException("Can't remove parameters");
    }
}
