/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

import webwork.util.ValueStack;

/**
 * A context used for to store information specific to a thread that wouldn't be appropriate to store in ActionContext.
 *
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 2 $
 * @see webwork.action.ActionContext
 */
public class CoreActionContext
{

    /**
     * Set the ValueStack.
     *
     * @param valueStack
     */
    public static void setValueStack(ValueStack valueStack)
    {
        ActionContext.setValueStack(valueStack);
    }

    /**
     * Returns the ValueStack specific to the current thread.
     *
     * @return ActionContext for the current thread
     */
    public static ValueStack getValueStack()
    {
        return ActionContext.getValueStack();
    }


}
