/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.sitemesh.webapp;

import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

public class ContentBufferingResponse
extends HttpServletResponseWrapper {
    private final PageResponseWrapper pageResponseWrapper;
    private final ContentProcessor contentProcessor;
    private final SiteMeshWebAppContext webAppContext;

    public ContentBufferingResponse(HttpServletResponse response, final ContentProcessor contentProcessor, final SiteMeshWebAppContext webAppContext) {
        super((HttpServletResponse)new PageResponseWrapper(response, new PageParserSelector(){

            @Override
            public boolean shouldParsePage(String contentType) {
                return contentProcessor.handles(contentType);
            }

            @Override
            public PageParser getPageParser(String contentType) {
                return null;
            }
        }){

            @Override
            public void setContentType(String contentType) {
                webAppContext.setContentType(contentType);
                super.setContentType(contentType);
            }
        });
        this.contentProcessor = contentProcessor;
        this.webAppContext = webAppContext;
        this.pageResponseWrapper = (PageResponseWrapper)this.getResponse();
    }

    public boolean isUsingStream() {
        return this.pageResponseWrapper.isUsingStream();
    }

    public Content getContent() throws IOException {
        char[] data = this.pageResponseWrapper.getContents();
        if (data != null) {
            return this.contentProcessor.build(data, this.webAppContext);
        }
        return null;
    }
}

